/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.build.Messages;
import com.espressif.idf.core.build.ReHintPair;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.resources.OpenDialogListenerSupport;
import com.espressif.idf.core.resources.PopupDialog;
import com.espressif.idf.core.resources.ResourceChangeListener;
import com.espressif.idf.core.tools.vo.IDFToolSet;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.ui.LaunchBarListener;
import com.espressif.idf.ui.dialogs.BuildView;
import com.espressif.idf.ui.dialogs.MessageLinkDialog;
import com.espressif.idf.ui.tools.ToolsActivationJob;
import com.espressif.idf.ui.tools.ToolsActivationJobListener;
import com.espressif.idf.ui.tools.manager.pages.ESPIDFMainTablePage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.launchbar.core.ILaunchBarListener;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class InitializeToolsStartup
implements IStartup {
    private static final String BUILDHINTS_ID = "com.espressif.idf.ui.views.buildhints";
    public static final String ESP_IDF_JSON_FILE = "esp_idf.json";
    private static final String GIT_PATH = "gitPath";
    private static final String IDF_TOOLS_PATH_KEY = "idfToolsPath";
    private static final String IDF_VERSIONS_ID = "idfSelectedId";
    private static final String IDF_INSTALLED_LIST_KEY = "idfInstalled";
    private static final String PYTHON_PATH = "python";
    private static final String IDF_PATH = "path";
    private static final String IS_INSTALLER_CONFIG_SET = "isInstallerConfigSet";
    private static final String DOC_URL = "\"https://docs.espressif.com/projects/esp-idf/en/latest/esp32/api-guides/partition-tables.html?highlight=partitions%20csv#creating-custom-tables\"";
    private String newIdfPath;
    private LaunchBarListener launchBarListener;

    public void earlyStartup() {
        OpenDialogListenerSupport.getSupport().addPropertyChangeListener(evt -> {
            PopupDialog popupDialog = PopupDialog.valueOf((String)evt.getPropertyName());
            switch (popupDialog) {
                case LOW_PARTITION_SIZE: {
                    this.openLowPartitionSizeDialog(evt);
                    break;
                }
                case AVAILABLE_HINTS: {
                    this.openAvailableHintsDialog(evt);
                    break;
                }
                case DISABLE_LAUNCHABAR_EVENTS: {
                    this.disableLaunchBarEvents(evt);
                    break;
                }
                case ENABLE_LAUNCHBAR_EVENTS: {
                    this.enableLaunchBarEvents(evt);
                    break;
                }
            }
        });
        this.launchBarListener = new LaunchBarListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener((ILaunchBarListener)this.launchBarListener));
        ILaunchBarManager launchBarManager = (ILaunchBarManager)Activator.getService(ILaunchBarManager.class);
        launchBarManager.addListener((ILaunchBarListener)this.launchBarListener);
        Location installLocation = Platform.getInstallLocation();
        URL url = installLocation.getURL();
        Logger.log((String)("Eclipse Install location::" + String.valueOf(url)));
        File idf_json_file = new File(url.getPath() + File.separator + ESP_IDF_JSON_FILE);
        if (!idf_json_file.exists()) {
            Logger.log((String)MessageFormat.format("esp-idf.json file doesn't exist at this location: '{0}'", url.getPath()));
            return;
        }
        if (this.isInstallerConfigSet()) {
            this.checkForUpdatedVersion(idf_json_file);
            if (this.isInstallerConfigSet()) {
                Logger.log((String)"Ignoring esp_idf.json settings as it was configured earilier and idf_path is similar.");
                return;
            }
            IDFEnvironmentVariables idfEnvMgr = new IDFEnvironmentVariables();
            Display.getDefault().syncExec(() -> {
                Shell shell = new Shell(Display.getDefault());
                MessageBox messageBox = new MessageBox(shell, 200);
                messageBox.setButtonLabels(Map.of(64, Messages.ToolsInitializationDifferentPathMessageBoxOptionYes, 128, Messages.ToolsInitializationDifferentPathMessageBoxOptionNo));
                messageBox.setText(Messages.ToolsInitializationDifferentPathMessageBoxTitle);
                messageBox.setMessage(MessageFormat.format(Messages.ToolsInitializationDifferentPathMessageBoxMessage, this.newIdfPath, idfEnvMgr.getEnvValue("IDF_PATH")));
                int response = messageBox.open();
                if (response == 128) {
                    IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
                    this.updateEspIdfJsonFile(idf_json_file, idfEnvironmentVariables.getEnvValue("IDF_PATH"));
                    Preferences prefs = this.getPreferences();
                    prefs.putBoolean(IS_INSTALLER_CONFIG_SET, true);
                    try {
                        prefs.flush();
                    }
                    catch (BackingStoreException e) {
                        Logger.log((Exception)((Object)e));
                    }
                    return;
                }
            });
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject jsonObj = (JSONObject)parser.parse((Reader)new FileReader(idf_json_file));
            String gitExecutablePath = (String)jsonObj.get((Object)GIT_PATH);
            String idfToolsPath = (String)jsonObj.get((Object)IDF_TOOLS_PATH_KEY);
            String idfVersionId = (String)jsonObj.get((Object)IDF_VERSIONS_ID);
            JSONObject list = (JSONObject)jsonObj.get((Object)IDF_INSTALLED_LIST_KEY);
            if (list != null) {
                JSONObject selectedIDFInfo = (JSONObject)list.get((Object)idfVersionId);
                String idfPath = (String)selectedIDFInfo.get((Object)IDF_PATH);
                String pythonExecutablePath = (String)selectedIDFInfo.get((Object)PYTHON_PATH);
                IDFToolSet newToolSet = new IDFToolSet();
                newToolSet.setIdfLocation(idfPath);
                newToolSet.setSystemGitExecutablePath(gitExecutablePath);
                newToolSet.setSystemPythonExecutablePath(pythonExecutablePath);
                newToolSet.setActive(true);
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.espressif.idf.core");
                prefs.put("IDF_TOOLS_PATH", idfToolsPath);
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    Logger.log((Exception)((Object)e));
                }
                ToolsActivationJob toolsActivationJob = new ToolsActivationJob(newToolSet, pythonExecutablePath, gitExecutablePath);
                ToolsActivationJobListener toolsActivationJobListener = new ToolsActivationJobListener(ESPIDFMainTablePage.getInstance());
                toolsActivationJob.addJobChangeListener((IJobChangeListener)toolsActivationJobListener);
                toolsActivationJob.schedule();
            }
            Preferences prefs = this.getPreferences();
            prefs.putBoolean(IS_INSTALLER_CONFIG_SET, true);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                Logger.log((Exception)((Object)e));
            }
            IDFUtil.updateEspressifPrefPageOpenocdPath();
        }
        catch (IOException | ParseException e) {
            Logger.log((Exception)e);
        }
    }

    private void disableLaunchBarEvents(PropertyChangeEvent evt) {
        LaunchBarListener.setIgnoreTargetChange(true);
    }

    private void enableLaunchBarEvents(PropertyChangeEvent evt) {
        LaunchBarListener.setIgnoreTargetChange(false);
    }

    private void openAvailableHintsDialog(PropertyChangeEvent evt) {
        Display.getDefault().asyncExec(() -> {
            List erroHintPairs = (List)evt.getNewValue();
            if (erroHintPairs.isEmpty()) {
                this.updateValuesInBuildView(erroHintPairs);
                return;
            }
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(BUILDHINTS_ID);
            }
            catch (PartInitException e) {
                Logger.log((Exception)((Object)e));
            }
            this.updateValuesInBuildView(erroHintPairs);
        });
    }

    private void updateValuesInBuildView(List<ReHintPair> erroHintPairs) {
        BuildView view = (BuildView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(BUILDHINTS_ID);
        if (view != null) {
            view.updateReHintsPairs(erroHintPairs);
        }
    }

    private void openLowPartitionSizeDialog(PropertyChangeEvent evt) {
        Display.getDefault().asyncExec(() -> MessageLinkDialog.openWarning(Display.getDefault().getActiveShell(), Messages.IncreasePartitionSizeTitle, MessageFormat.format(Messages.IncreasePartitionSizeMessage, evt.getNewValue(), evt.getOldValue(), DOC_URL)));
    }

    private void updateEspIdfJsonFile(File idf_json_file, String newIdfPathToUpdate) {
        Object var6_10;
        JSONParser parser = new JSONParser();
        JSONObject jsonObj = null;
        try {
            Throwable throwable = null;
            var6_10 = null;
            try (FileReader reader = new FileReader(idf_json_file);){
                jsonObj = (JSONObject)parser.parse((Reader)reader);
                String idfVersionId = (String)jsonObj.get((Object)IDF_VERSIONS_ID);
                JSONObject list = (JSONObject)jsonObj.get((Object)IDF_INSTALLED_LIST_KEY);
                if (list == null) {
                    return;
                }
                JSONObject selectedIDFInfo = (JSONObject)list.get((Object)idfVersionId);
                selectedIDFInfo.put((Object)IDF_PATH, (Object)newIdfPathToUpdate);
                list.put((Object)idfVersionId, (Object)selectedIDFInfo);
                jsonObj.put((Object)IDF_INSTALLED_LIST_KEY, (Object)list);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParseException e) {
            Logger.log((Exception)e);
        }
        if (jsonObj != null) {
            try {
                e = null;
                var6_10 = null;
                try (FileWriter fileWriter = new FileWriter(idf_json_file);){
                    fileWriter.write(jsonObj.toJSONString());
                    fileWriter.flush();
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }
    }

    private void checkForUpdatedVersion(File idf_json_file) {
        JSONParser parser = new JSONParser();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileReader reader = new FileReader(idf_json_file);){
                JSONObject jsonObj = (JSONObject)parser.parse((Reader)reader);
                String idfVersionId = (String)jsonObj.get((Object)IDF_VERSIONS_ID);
                JSONObject list = (JSONObject)jsonObj.get((Object)IDF_INSTALLED_LIST_KEY);
                if (list == null) {
                    return;
                }
                JSONObject selectedIDFInfo = (JSONObject)list.get((Object)idfVersionId);
                String idfPath = (String)selectedIDFInfo.get((Object)IDF_PATH);
                IDFEnvironmentVariables idfEnvMgr = new IDFEnvironmentVariables();
                if (idfEnvMgr.getEnvValue("IDF_PATH").equals(idfPath)) {
                    return;
                }
                this.newIdfPath = idfPath;
                Preferences prefs = this.getPreferences();
                prefs.putBoolean(IS_INSTALLER_CONFIG_SET, false);
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    Logger.log((Exception)((Object)e));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParseException e) {
            Logger.log((Exception)e);
        }
    }

    private Preferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("com.espressif.idf.ui");
    }

    private boolean isInstallerConfigSet() {
        return this.getPreferences().getBoolean(IS_INSTALLER_CONFIG_SET, false);
    }
}

