/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui;

import com.espressif.idf.core.IDFProjectNature;
import com.espressif.idf.core.logging.Logger;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EclipseUtil {
    public static IResource getSelectionResource() {
        StructuredSelection selection;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        Object object = selection = selectionService != null ? selectionService.getSelection() : StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IResource) {
                return (IResource)element;
            }
            if (element instanceof IAdaptable) {
                return (IResource)((IAdaptable)element).getAdapter(IResource.class);
            }
        }
        return null;
    }

    public static IProject getSelectedProjectInExplorer() {
        return EclipseUtil.getSelectedProject("org.eclipse.ui.navigator.ProjectExplorer");
    }

    public static IProject getSelectedIDFProjectInExplorer() {
        IProject project = EclipseUtil.getSelectedProject("org.eclipse.ui.navigator.ProjectExplorer");
        try {
            if (project != null && project.isOpen() && project.hasNature(IDFProjectNature.ID)) {
                return project;
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return null;
    }

    public static Optional<IProject> getDefaultIDFProject() {
        Optional<IProject> defaultProject = EclipseUtil.getSelectedProject();
        return defaultProject.isPresent() ? defaultProject : EclipseUtil.getFirstAvailableIDFProject();
    }

    private static Optional<IProject> getSelectedProject() {
        ArrayList selectedProject = new ArrayList();
        Display.getDefault().syncExec(() -> {
            IProject project = EclipseUtil.getSelectedIDFProjectInExplorer();
            selectedProject.add(Optional.ofNullable(project));
        });
        return (Optional)selectedProject.get(0);
    }

    private static Optional<IProject> getFirstAvailableIDFProject() {
        try {
            ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
            return Stream.of(projects).map(ICProject::getProject).filter(EclipseUtil::hasIDFProjectNature).findFirst();
        }
        catch (CModelException e) {
            Logger.log((Exception)((Object)e));
            return Optional.empty();
        }
    }

    private static boolean hasIDFProjectNature(IProject project) {
        try {
            return project.hasNature(IDFProjectNature.ID);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            return false;
        }
    }

    private static IProject getSelectedProject(String viewID) {
        IResource resource;
        Object selectedObject;
        ISelectionService service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        IStructuredSelection structured = (IStructuredSelection)service.getSelection(viewID);
        if (structured instanceof IStructuredSelection && (selectedObject = structured.getFirstElement()) instanceof IAdaptable && (resource = (IResource)((IAdaptable)selectedObject).getAdapter(IResource.class)) != null) {
            return resource.getProject();
        }
        return null;
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }
}

