/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing;

import com.espressif.idf.core.logging.Logger;
import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class TracingUtil {
    public static void launchEditor(String fullFilePath) {
        final File fileToOpen = new File(fullFilePath);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (fileToOpen.exists() && fileToOpen.isFile()) {
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    catch (PartInitException e) {
                        Logger.log((Exception)((Object)e));
                    }
                }
            }
        });
    }

    public static void goToLineNumber(int lineNumber) {
        ITextEditor editor = (ITextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)editor.getEditorInput());
        try {
            int start = document.getLineOffset(--lineNumber);
            editor.selectAndReveal(start, 0);
            IWorkbenchPage page = editor.getSite().getPage();
            page.activate((IWorkbenchPart)editor);
        }
        catch (Exception e) {
            Logger.log((Exception)e);
        }
    }
}

