/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tools.manager.pages;

import com.espressif.idf.core.tools.ToolSetConfigurationManager;
import com.espressif.idf.core.tools.vo.IDFToolSet;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.ui.UIPlugin;
import com.espressif.idf.ui.install.IDFNewToolsWizard;
import com.espressif.idf.ui.tools.Messages;
import com.espressif.idf.ui.tools.ToolsActivationJob;
import com.espressif.idf.ui.tools.ToolsActivationJobListener;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ESPIDFMainTablePage {
    private Composite container;
    private TableViewer tableViewer;
    private ToolSetConfigurationManager toolSetConfigurationManager;
    private ColumnViewerComparator comparator;
    private TableViewerColumn versionColumn;
    private TableViewerColumn locationColumn;
    private TableViewerColumn activateColumn;
    private TableViewerColumn removeColumn;
    private TableColumnLayout tableColumnLayout;
    private Composite tableComposite;
    private List<IDFToolSet> idfToolSets;
    private Button removeAllButton;
    private static final String REMOVE_ICON = "icons/tools/delete.png";
    private static final String RELOAD_ICON = "icons/tools/reload.png";
    private static final String IDF_TOOL_SET_BTN_KEY = "IDFToolSet";
    private static ESPIDFMainTablePage espidfMainTablePage;

    private ESPIDFMainTablePage() {
    }

    public static ESPIDFMainTablePage getInstance() {
        if (espidfMainTablePage == null) {
            espidfMainTablePage = new ESPIDFMainTablePage();
        }
        return espidfMainTablePage;
    }

    public Composite createPage(Composite composite) {
        this.toolSetConfigurationManager = new ToolSetConfigurationManager();
        this.idfToolSets = this.toolSetConfigurationManager.getIdfToolSets(true);
        this.container = new Composite(composite, 0);
        int numColumns = 2;
        GridLayout gridLayout = new GridLayout(2, false);
        this.container.setLayout((Layout)gridLayout);
        this.createIdfTable(this.container);
        return this.container;
    }

    public void refreshEditorUI() {
        if (this.container == null) {
            return;
        }
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String EDITOR_KEY = "action_editor";
            String EDITOR_KEY_LAST = "action_editor_last";
            TableEditor editorFirst = (TableEditor)item.getData(EDITOR_KEY);
            TableEditor editorLast = (TableEditor)item.getData(EDITOR_KEY_LAST);
            if (editorFirst != null) {
                if (editorFirst.getEditor() != null && !editorFirst.getEditor().isDisposed()) {
                    editorFirst.getEditor().dispose();
                }
                editorFirst.dispose();
                item.setData(EDITOR_KEY, null);
            }
            if (editorLast != null) {
                if (editorLast.getEditor() != null && !editorLast.getEditor().isDisposed()) {
                    editorLast.getEditor().dispose();
                }
                editorLast.dispose();
                item.setData(EDITOR_KEY_LAST, null);
            }
            ++n2;
        }
        this.toolSetConfigurationManager.setReload(true);
        this.idfToolSets = this.toolSetConfigurationManager.getIdfToolSets(true);
        this.setupColumns();
        this.tableViewer.setInput(this.idfToolSets);
        this.tableViewer.getControl().requestLayout();
        this.tableViewer.refresh();
        this.container.redraw();
        this.toolSetConfigurationManager.setReload(false);
        if (this.idfToolSets == null || this.idfToolSets.isEmpty()) {
            this.removeAllButton.setEnabled(false);
        } else {
            this.removeAllButton.setEnabled(true);
        }
    }

    private Composite createIdfTable(Composite parent) {
        Group idfToolsGroup = new Group(parent, 16);
        idfToolsGroup.setText("IDF Tools");
        idfToolsGroup.setLayout((Layout)new GridLayout(2, false));
        idfToolsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableComposite = new Composite((Composite)idfToolsGroup, 0);
        this.tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableColumnLayout = new TableColumnLayout();
        this.tableComposite.setLayout((Layout)this.tableColumnLayout);
        this.tableViewer = new TableViewer(this.tableComposite, 2304);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(41, event -> {
            event.height = 25;
        });
        this.comparator = new ColumnViewerComparator();
        this.tableViewer.setComparator((ViewerComparator)this.comparator);
        this.setupColumns();
        table.addListener(41, e -> {
            e.height = 30;
        });
        this.tableViewer.setInput((Object)this.toolSetConfigurationManager.getIdfToolSets(true));
        table.layout();
        Composite buttonComposite = new Composite((Composite)idfToolsGroup, 0);
        GridData buttonCompositeGridData = new GridData(131072, 0x1000000, false, false);
        buttonCompositeGridData.verticalAlignment = 128;
        buttonComposite.setLayoutData((Object)buttonCompositeGridData);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setText(Messages.EspIdfManagerAddToolsBtn);
        GridData addButtonGridData = new GridData(4, 0x1000000, true, false);
        addButton.setLayoutData((Object)addButtonGridData);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDFNewToolsWizard wizard = new IDFNewToolsWizard(ESPIDFMainTablePage.this);
                wizard.setWindowTitle(Messages.IDFDownloadHandler_ESPIDFConfiguration);
                WizardDialog wizDialog = new WizardDialog(ESPIDFMainTablePage.this.container.getShell(), (IWizard)wizard);
                wizDialog.create();
                wizDialog.setTitle(Messages.IDFDownloadHandler_DownloadPage_Title);
                wizDialog.setMessage(Messages.IDFDownloadHandler_DownloadPageMsg);
                wizDialog.getShell().setSize(Math.max(850, wizDialog.getShell().getSize().x), 550);
                wizDialog.open();
            }
        });
        this.removeAllButton = new Button(buttonComposite, 8);
        this.removeAllButton.setText(Messages.EspIdfManagerRemoveAllBtn);
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 200);
                messageBox.setMessage(Messages.EspIdfManagerMessageBoxDeleteAllConfirmMessage);
                messageBox.setText(Messages.EspIdfManagerMessageBoxDeleteAllConfirmMessageTitle);
                int response = messageBox.open();
                if (response == 64) {
                    for (IDFToolSet idfToolSet : ESPIDFMainTablePage.this.idfToolSets) {
                        ESPIDFMainTablePage.this.toolSetConfigurationManager.delete(idfToolSet);
                    }
                    ESPIDFMainTablePage.this.refreshEditorUI();
                }
            }
        });
        GridData removeAllButtonGridData = new GridData(4, 0x1000000, true, false);
        this.removeAllButton.setLayoutData((Object)removeAllButtonGridData);
        if (this.idfToolSets == null || this.idfToolSets.isEmpty()) {
            this.removeAllButton.setEnabled(false);
        } else {
            this.removeAllButton.setEnabled(true);
        }
        return idfToolsGroup;
    }

    private void disposeColumns() {
        if (this.activateColumn != null && this.activateColumn.getColumn() != null) {
            this.activateColumn.getColumn().dispose();
        }
        if (this.versionColumn != null && this.versionColumn.getColumn() != null) {
            this.versionColumn.getColumn().dispose();
        }
        if (this.locationColumn != null && this.locationColumn.getColumn() != null) {
            this.locationColumn.getColumn().dispose();
        }
        if (this.removeColumn != null && this.removeColumn.getColumn() != null) {
            this.removeColumn.getColumn().dispose();
        }
    }

    private void setupColumns() {
        this.disposeColumns();
        int colIndex = 0;
        this.activateColumn = new TableViewerColumn(this.tableViewer, 0);
        this.activateColumn.getColumn().setText(Messages.EspIdfManagerActivateCol);
        this.activateColumn.setLabelProvider((CellLabelProvider)new IdfManagerTableColumnLabelProvider());
        this.tableColumnLayout.setColumnData((Widget)this.activateColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(2, 5, true));
        this.versionColumn = new TableViewerColumn(this.tableViewer, 0);
        this.versionColumn.getColumn().setText(Messages.EspIdfManagerVersionCol);
        this.versionColumn.setLabelProvider((CellLabelProvider)new IdfManagerTableColumnLabelProvider());
        this.setComparatorForCols(this.versionColumn, colIndex++);
        this.tableColumnLayout.setColumnData((Widget)this.versionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(3, 50, true));
        this.locationColumn = new TableViewerColumn(this.tableViewer, 0);
        this.locationColumn.getColumn().setText(Messages.EspIdfManagerLocationCol);
        this.locationColumn.setLabelProvider((CellLabelProvider)new IdfManagerTableColumnLabelProvider());
        this.setComparatorForCols(this.locationColumn, colIndex++);
        this.tableColumnLayout.setColumnData((Widget)this.locationColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 100, true));
        this.removeColumn = new TableViewerColumn(this.tableViewer, 0);
        this.removeColumn.setLabelProvider((CellLabelProvider)new IdfManagerTableColumnLabelProvider());
        this.tableColumnLayout.setColumnData((Widget)this.removeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(3, 100, true));
    }

    private void setComparatorForCols(final TableViewerColumn column, final int colIndex) {
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ESPIDFMainTablePage.this.comparator.setColumn(colIndex);
                int direction = ESPIDFMainTablePage.this.tableViewer.getTable().getSortDirection();
                direction = ESPIDFMainTablePage.this.tableViewer.getTable().getSortColumn() == column.getColumn() ? (direction == 128 ? 1024 : 128) : 1024;
                ESPIDFMainTablePage.this.tableViewer.getTable().setSortDirection(direction);
                ESPIDFMainTablePage.this.tableViewer.getTable().setSortColumn(column.getColumn());
                ESPIDFMainTablePage.this.tableViewer.refresh();
            }
        });
    }

    private void performDeleteOperation(IDFToolSet idfToolSet) {
        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 200);
        messageBox.setMessage(MessageFormat.format(Messages.EspIdfManagerMessageBoxDeleteConfirmMessage, idfToolSet.getIdfVersion()));
        messageBox.setText(Messages.EspIdfManagerMessageBoxDeleteConfirmMessageTitle);
        int response = messageBox.open();
        if (response == 64) {
            this.toolSetConfigurationManager.delete(idfToolSet);
        }
    }

    private class ColumnViewerComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IDFToolSet p1 = (IDFToolSet)e1;
            IDFToolSet p2 = (IDFToolSet)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = p1.getIdfVersion().compareTo(p2.getIdfVersion());
                    break;
                }
                case 1: {
                    rc = p1.getIdfLocation().compareTo(p2.getIdfLocation());
                    break;
                }
                case 2: {
                    Boolean p1State = p1.isActive();
                    Boolean p2State = p2.isActive();
                    rc = p1State.compareTo(p2State);
                    break;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    private class IdfManagerTableColumnLabelProvider
    extends ColumnLabelProvider {
        private Color activeBackgroundColor = new Color((Device)Display.getCurrent(), 144, 238, 144);

        private IdfManagerTableColumnLabelProvider() {
        }

        public Color getBackground(Object element) {
            IDFToolSet idfToolSet;
            if (element instanceof IDFToolSet && (idfToolSet = (IDFToolSet)element).isActive()) {
                return this.activeBackgroundColor;
            }
            return null;
        }

        public void update(ViewerCell cell) {
            boolean isFirstCol;
            int totalCols = ESPIDFMainTablePage.this.tableViewer.getTable().getColumnCount();
            boolean isLastCol = cell.getColumnIndex() == totalCols - 1;
            boolean bl = isFirstCol = cell.getColumnIndex() == 0;
            if (isFirstCol) {
                this.createButtonsForFirstCol(cell);
            } else if (isLastCol) {
                this.createButtonsForLastCol(cell);
            } else {
                this.updateDataIntoCells(cell);
            }
            Color color = this.getBackground(cell.getElement());
            if (color != null) {
                cell.setBackground(color);
            }
        }

        private void updateDataIntoCells(ViewerCell cell) {
            if (!(cell.getElement() instanceof IDFToolSet) && cell.getElement() == null) {
                return;
            }
            IDFToolSet idfToolSet = (IDFToolSet)cell.getElement();
            switch (cell.getColumnIndex()) {
                case 0: {
                    break;
                }
                case 1: {
                    cell.setText(idfToolSet.getIdfVersion());
                    break;
                }
                case 2: {
                    cell.setText(idfToolSet.getIdfLocation());
                    break;
                }
            }
        }

        private void createButtonsForFirstCol(ViewerCell cell) {
            String EDITOR_KEY;
            TableItem item = (TableItem)cell.getItem();
            if (item.getData(EDITOR_KEY = "action_editor") != null) {
                return;
            }
            TableEditor editor = new TableEditor(ESPIDFMainTablePage.this.tableViewer.getTable());
            Composite buttonComposite = new Composite((Composite)ESPIDFMainTablePage.this.tableViewer.getTable(), 0);
            buttonComposite.setLayout((Layout)new FillLayout());
            item.setData(EDITOR_KEY, (Object)editor);
            IDFToolSet idfToolSet = (IDFToolSet)cell.getElement();
            Button setActiveButton = new Button(buttonComposite, 16);
            setActiveButton.setSelection(idfToolSet.isActive());
            setActiveButton.setData(ESPIDFMainTablePage.IDF_TOOL_SET_BTN_KEY, (Object)idfToolSet);
            setActiveButton.addListener(13, e -> {
                Button btn = (Button)e.widget;
                ToolsActivationJob toolsActivationJob = new ToolsActivationJob((IDFToolSet)btn.getData(ESPIDFMainTablePage.IDF_TOOL_SET_BTN_KEY), null, null);
                ToolsActivationJobListener toolsActivationJobListener = new ToolsActivationJobListener(ESPIDFMainTablePage.this);
                toolsActivationJob.addJobChangeListener((IJobChangeListener)toolsActivationJobListener);
                toolsActivationJob.schedule();
                btn.setEnabled(false);
            });
            editor.grabHorizontal = true;
            editor.setEditor((Control)buttonComposite, item, cell.getColumnIndex());
        }

        private void createButtonsForLastCol(ViewerCell cell) {
            TableItem item = (TableItem)cell.getItem();
            Rectangle cellBounds = cell.getBounds();
            String EDITOR_KEY = "action_editor_last";
            if (item.getData(EDITOR_KEY) != null) {
                return;
            }
            TableEditor editor = new TableEditor(ESPIDFMainTablePage.this.tableViewer.getTable());
            Composite buttonComposite = new Composite((Composite)ESPIDFMainTablePage.this.tableViewer.getTable(), 0);
            FillLayout fillLayout = new FillLayout(256);
            buttonComposite.setLayout((Layout)fillLayout);
            buttonComposite.redraw();
            item.setData(EDITOR_KEY, (Object)editor);
            IDFToolSet idfToolSet = (IDFToolSet)cell.getElement();
            int buttonHeight = Math.min(cellBounds.height - 6, 30);
            if (idfToolSet.isActive()) {
                Button reloadButton = new Button(buttonComposite, 0x800008);
                reloadButton.pack();
                reloadButton.setData(ESPIDFMainTablePage.IDF_TOOL_SET_BTN_KEY, (Object)idfToolSet);
                reloadButton.setImage(UIPlugin.getImage(ESPIDFMainTablePage.RELOAD_ICON));
                reloadButton.setToolTipText(Messages.EspIdfManagerReloadBtnToolTip);
                reloadButton.addListener(13, e -> {
                    Button btn = (Button)e.widget;
                    IDFToolSet selectedToolSet = (IDFToolSet)btn.getData(ESPIDFMainTablePage.IDF_TOOL_SET_BTN_KEY);
                    ToolsActivationJob toolsActivationJob = new ToolsActivationJob(selectedToolSet, IDFUtil.getPythonExecutable(), IDFUtil.getGitExecutablePathFromSystem());
                    ToolsActivationJobListener toolsActivationJobListener = new ToolsActivationJobListener(ESPIDFMainTablePage.this);
                    toolsActivationJob.addJobChangeListener((IJobChangeListener)toolsActivationJobListener);
                    toolsActivationJob.schedule();
                });
                reloadButton.setSize(cellBounds.width, buttonHeight);
                reloadButton.addListener(9, e -> e.gc.drawRectangle(reloadButton.getBounds()));
                reloadButton.redraw();
            }
            Button removeButton = new Button(buttonComposite, 0x800008);
            removeButton.pack();
            removeButton.setData(ESPIDFMainTablePage.IDF_TOOL_SET_BTN_KEY, (Object)idfToolSet);
            removeButton.setImage(UIPlugin.getImage(ESPIDFMainTablePage.REMOVE_ICON));
            removeButton.setToolTipText(Messages.EspIdfManagerDeleteBtnToolTip);
            removeButton.addListener(13, e -> {
                Button btn = (Button)e.widget;
                IDFToolSet selectedToolSet = (IDFToolSet)btn.getData(ESPIDFMainTablePage.IDF_TOOL_SET_BTN_KEY);
                ESPIDFMainTablePage.this.performDeleteOperation(selectedToolSet);
                ESPIDFMainTablePage.this.refreshEditorUI();
            });
            removeButton.setSize(cellBounds.width, buttonHeight);
            removeButton.redraw();
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.horizontalAlignment = 0x1000000;
            editor.verticalAlignment = 0x1000000;
            editor.minimumHeight = removeButton.getSize().y;
            editor.minimumWidth = removeButton.getSize().x;
            editor.setEditor((Control)buttonComposite, item, cell.getColumnIndex());
            buttonComposite.layout(true, true);
            buttonComposite.redraw();
            editor.layout();
            ESPIDFMainTablePage.this.tableViewer.getTable().layout(true, true);
        }

        public void dispose() {
            if (this.activeBackgroundColor != null && !this.activeBackgroundColor.isDisposed()) {
                this.activeBackgroundColor.dispose();
            }
            super.dispose();
        }
    }
}

