/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tools;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.ToolSetConfigurationManager;
import com.espressif.idf.core.tools.vo.IDFToolSet;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.IDFConsole;
import com.espressif.idf.ui.InputStreamConsoleThread;
import com.espressif.idf.ui.update.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.MessageConsoleStream;

public abstract class ToolsJob
extends Job {
    protected IDFConsole idfConsole;
    protected MessageConsoleStream console;
    protected MessageConsoleStream errorConsoleStream;
    protected String pythonExecutablePath;
    protected String gitExecutablePath;
    protected IDFToolSet idfToolSet;
    protected ToolSetConfigurationManager toolSetConfigurationManager;
    protected String idfPath;

    public ToolsJob(String name, String pythonExecutablePath, String gitExecutablePath) {
        super(name);
        this.pythonExecutablePath = pythonExecutablePath;
        this.gitExecutablePath = gitExecutablePath;
        this.idfToolSet = new IDFToolSet();
        this.toolSetConfigurationManager = new ToolSetConfigurationManager();
        this.activateIDFConsoleView();
    }

    protected void processExportCmdOutput(String exportCmdOp) {
        String[] exportEntries;
        String[] stringArray = exportEntries = exportCmdOp.split("\n");
        int n = exportEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String[] keyValue;
            String entry = stringArray[n2];
            if ((entry = entry.replaceAll("\\r", "")).startsWith("Error")) {
                try {
                    this.errorConsoleStream.write(entry);
                }
                catch (IOException e) {
                    Logger.log((Exception)e);
                }
            }
            if ((keyValue = entry.split("=")).length == 2) {
                String msg = MessageFormat.format("Key: {0} Value: {1}", keyValue[0], keyValue[1]);
                Logger.log((String)msg);
                String key = keyValue[0];
                String value = keyValue[1];
                if (this.idfToolSet.getEnvVars() == null) {
                    this.idfToolSet.setEnvVars(new HashMap());
                }
                this.idfToolSet.getEnvVars().put(key, value);
            }
            ++n2;
        }
        this.idfToolSet.getEnvVars().put("IDF_COMPONENT_MANAGER", "1");
        this.idfToolSet.getEnvVars().put("IDF_MAINTAINER", "1");
        if (!StringUtil.isEmpty((String)this.idfPath)) {
            this.idfToolSet.getEnvVars().put("IDF_PATH", this.idfPath);
            this.idfToolSet.setIdfLocation(this.idfPath);
        }
        IStatus status = this.getIdfVersionFromIdfPy();
        String cmdOutput = status.getMessage();
        Pattern pattern = Pattern.compile("v(\\d+\\.\\d+\\.\\d+)");
        Matcher matcher = pattern.matcher(cmdOutput.toLowerCase());
        if (matcher.find()) {
            this.idfToolSet.setIdfVersion(matcher.group(1));
        } else {
            this.idfToolSet.setIdfVersion(this.idfToolSet.getEnvVars().computeIfAbsent("ESP_IDF_VERSION", k -> ""));
        }
        this.idfToolSet.getEnvVars().put("ESP_IDF_VERSION", this.idfToolSet.getIdfVersion());
    }

    protected String replacePathVariable(String value) {
        HashMap systemEnv = new HashMap(IDFUtil.getSystemEnv());
        String pathEntry = (String)systemEnv.get("PATH");
        if (pathEntry == null && (pathEntry = (String)systemEnv.get("Path")) == null) {
            Logger.log((Exception)new Exception("No PATH found in the system environment variables"));
        }
        if (!StringUtil.isEmpty((String)pathEntry)) {
            value = value.replace("$PATH", pathEntry);
            value = value.replace("%PATH%", pathEntry);
        }
        return value;
    }

    protected IStatus loadTargetsAvailableFromIdfInCurrentToolSet() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--list-targets");
        return this.runCommandIdfPyInIdfEnv(arguments, this.console);
    }

    protected List<String> extractTargets(String input) {
        ArrayList<String> targets = new ArrayList<String>();
        Pattern pattern = Pattern.compile("^esp32.*", 8);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            targets.add(matcher.group());
        }
        return targets;
    }

    protected IStatus handleWebSocketClientInstall() {
        String websocketClient = "websocket-client";
        ArrayList<String> arguments = new ArrayList<String>();
        String pythonEnvPath = this.pythonVirtualExecutablePath(this.idfToolSet);
        if (pythonEnvPath == null || !new File(pythonEnvPath).exists()) {
            this.console.println(String.format("%s executable not found. Unable to run `%s -m pip install websocket-client`", "python", "python"));
            return IDFCorePlugin.errorStatus((String)String.format("%s executable not found. Unable to run `%s -m pip install websocket-client`", "python", "python"), null);
        }
        arguments.add(pythonEnvPath);
        arguments.add("-m");
        arguments.add("pip");
        arguments.add("list");
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            String cmdMsg = "Executing " + this.getCommandString(arguments);
            if (this.console != null) {
                this.console.println(cmdMsg);
            }
            Logger.log((String)cmdMsg);
            HashMap environment = new HashMap(IDFUtil.getSystemEnv());
            Logger.log((String)((Object)environment).toString());
            IStatus status = processRunner.runInBackground(arguments, (IPath)Path.ROOT, environment);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Unable to get the process status.", null));
                if (this.errorConsoleStream != null) {
                    this.errorConsoleStream.println("Unable to get the process status.");
                }
                return IDFCorePlugin.errorStatus((String)"Unable to get the process status.", null);
            }
            String cmdOutput = status.getMessage();
            if (cmdOutput.contains(websocketClient)) {
                return IDFCorePlugin.okStatus((String)"websocket-client already installed", null);
            }
            arguments.remove(arguments.size() - 1);
            arguments.add("install");
            arguments.add(websocketClient);
            status = processRunner.runInBackground(arguments, (IPath)Path.ROOT, environment);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Unable to get the process status.", null));
                if (this.errorConsoleStream != null) {
                    this.errorConsoleStream.println("Unable to get the process status.");
                }
                return IDFCorePlugin.errorStatus((String)"Unable to get the process status.", null);
            }
            if (this.console != null) {
                this.console.println(status.getMessage());
            }
            return status;
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
            if (this.errorConsoleStream != null) {
                this.errorConsoleStream.println(e1.getLocalizedMessage());
            }
            return IDFCorePlugin.errorStatus((String)e1.getLocalizedMessage(), (Exception)e1);
        }
    }

    protected String pythonVirtualExecutablePath(IDFToolSet idfToolSet) {
        String pythonVirtualPath = (String)idfToolSet.getEnvVars().get("IDF_PYTHON_ENV_PATH");
        StringBuilder pythonVirtualExePath = new StringBuilder();
        pythonVirtualExePath.append(pythonVirtualPath);
        pythonVirtualExePath.append("/");
        if (Platform.getOS().equals("win32")) {
            pythonVirtualExePath.append("Scripts");
            pythonVirtualExePath.append("/");
            pythonVirtualExePath.append("python.exe");
        } else {
            pythonVirtualExePath.append("bin");
            pythonVirtualExePath.append("/");
            pythonVirtualExePath.append("python");
        }
        return pythonVirtualExePath.toString();
    }

    private String getCommandString(List<String> arguments) {
        StringBuilder builder = new StringBuilder();
        arguments.forEach(entry -> {
            StringBuilder stringBuilder2 = builder.append(entry + " ");
        });
        return builder.toString().trim();
    }

    protected void activateIDFConsoleView() {
        this.idfConsole = new IDFConsole();
        this.console = this.idfConsole.getConsoleStream(Messages.IDFToolsHandler_ToolsManagerConsole, null, false, true);
        this.errorConsoleStream = this.idfConsole.getConsoleStream(Messages.IDFToolsHandler_ToolsManagerConsole, null, true, true);
    }

    protected IStatus getIdfVersionFromIdfPy() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--version");
        return this.runCommandIdfPyInIdfEnv(arguments, this.console);
    }

    protected String appendGitToPath(String path, String gitExecutablePath) {
        Path gitPath = new Path(gitExecutablePath);
        if (!gitPath.toFile().exists()) {
            Logger.log((String)NLS.bind((String)"{0} doesn't exist", (Object)gitExecutablePath));
            return path;
        }
        String gitDir = gitPath.removeLastSegments(1).toOSString();
        if (!StringUtil.isEmpty((String)path) && !path.contains(gitDir)) {
            return path.concat(";").concat(gitDir);
        }
        return path;
    }

    protected IStatus runCommandIdfPyInIdfEnv(List<String> arguments, MessageConsoleStream console) {
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        StringBuilder output = new StringBuilder();
        int waitCount = 10;
        try {
            String line;
            arguments.add(0, this.pythonVirtualExecutablePath(this.idfToolSet));
            arguments.add(1, IDFUtil.getIDFPythonScriptFile((String)this.idfToolSet.getIdfLocation()).getAbsolutePath());
            String cmdMsg = Messages.AbstractToolsHandler_ExecutingMsg + " " + this.getCommandString(arguments);
            console.println(cmdMsg);
            Logger.log((String)cmdMsg);
            HashMap<String, String> environment = new HashMap<String, String>(IDFUtil.getSystemEnv());
            Logger.log((String)((Object)environment).toString());
            environment.put("PYTHONUNBUFFERED", "1");
            this.loadIdfPathWithSystemPath(environment);
            environment.remove("IDF_PYTHON_ENV_PATH");
            environment.remove("ESP_IDF_VERSION");
            environment.remove("IDF_PATH");
            environment.remove("OPENOCD_SCRIPTS");
            if (this.gitExecutablePath != null) {
                this.addPathToEnvironmentPath(environment, this.gitExecutablePath);
            }
            Process process = processRunner.run(arguments, (IPath)Path.ROOT, environment);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                output.append(line).append(System.lineSeparator());
            }
            while (process.isAlive() && waitCount > 0) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    Logger.log((Exception)e);
                }
                --waitCount;
            }
            if (waitCount == 0) {
                console.println("Process possibly stuck");
                Logger.log((String)"Process possibly stuck");
                return Status.CANCEL_STATUS;
            }
            Status status = new Status(process.exitValue() == 0 ? 0 : 4, "com.espressif.idf.ui", process.exitValue(), output.toString(), null);
            if (status.getSeverity() == 4) {
                this.errorConsoleStream.print(status.getException() != null ? status.getException().getMessage() : status.getMessage());
            }
            console.println(status.getMessage());
            console.println();
            return status;
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
            return IDFCorePlugin.errorStatus((String)e1.getMessage(), (Exception)e1);
        }
    }

    private void addPathToEnvironmentPath(Map<String, String> environment, String gitExecutablePath) {
        Path gitPath = new Path(gitExecutablePath);
        if (gitPath.toFile().exists()) {
            String gitDir = gitPath.removeLastSegments(1).toOSString();
            String path1 = environment.get("PATH");
            String path2 = environment.get("Path");
            if (!StringUtil.isEmpty((String)path1) && !path1.contains(gitDir)) {
                path1 = gitDir.concat(";").concat(path1);
                environment.put("PATH", path1);
            } else if (!StringUtil.isEmpty((String)path2) && !path2.contains(gitDir)) {
                path2 = gitDir.concat(";").concat(path2);
                environment.put("Path", path2);
            }
        }
    }

    private void loadIdfPathWithSystemPath(Map<String, String> systemEnv) {
        String idfExportPath = (String)this.idfToolSet.getEnvVars().get("PATH");
        String pathVar = "PATH";
        String pathEntry = systemEnv.get(pathVar);
        if (pathEntry == null && (pathEntry = systemEnv.get(pathVar = "Path")) == null) {
            Logger.log((Exception)new Exception("No PATH found in the system environment variables"));
        }
        if (!StringUtil.isEmpty((String)pathEntry)) {
            idfExportPath = idfExportPath.replace("$PATH", pathEntry);
            idfExportPath = idfExportPath.replace("%PATH%", pathEntry);
        }
        systemEnv.put(pathVar, idfExportPath);
        for (Map.Entry entry : this.idfToolSet.getEnvVars().entrySet()) {
            if (((String)entry.getKey()).equals("PATH")) continue;
            systemEnv.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected IStatus runCommand(List<String> arguments, MessageConsoleStream console) {
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            arguments.add(0, this.pythonExecutablePath);
            arguments.add(1, IDFUtil.getIDFToolsScriptFile((String)this.idfToolSet.getIdfLocation()).getAbsolutePath());
            String cmdMsg = Messages.AbstractToolsHandler_ExecutingMsg + " " + this.getCommandString(arguments);
            console.println(cmdMsg);
            Logger.log((String)cmdMsg);
            HashMap<String, String> environment = new HashMap<String, String>(IDFUtil.getSystemEnv());
            Logger.log((String)((Object)environment).toString());
            environment.put("PYTHONUNBUFFERED", "1");
            environment.put("IDF_GITHUB_ASSETS", Platform.getPreferencesService().getString("com.espressif.idf.core", "IDF_GITHUB_ASSETS", "dl.espressif.com/github_assets", null));
            environment.put("PIP_EXTRA_INDEX_URL", Platform.getPreferencesService().getString("com.espressif.idf.core", "PIP_EXTRA_INDEX_URL", "https://dl.espressif.com/pypi", null));
            if (this.gitExecutablePath != null) {
                this.addPathToEnvironmentPath(environment, this.gitExecutablePath);
            }
            Process process = processRunner.run(arguments, (IPath)Path.ROOT, environment);
            IStatus status = this.processData(process);
            console.println();
            return IDFCorePlugin.okStatus((String)status.getMessage(), null);
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
            return IDFCorePlugin.errorStatus((String)e1.getMessage(), (Exception)e1);
        }
    }

    private IStatus processData(Process process) {
        InputStream inputStream = process.getInputStream();
        InputStream errorStream = process.getErrorStream();
        InputStreamConsoleThread readerThread = null;
        Thread errorThread = null;
        try {
            readerThread = new InputStreamConsoleThread(inputStream, this.console);
            errorThread = new InputStreamConsoleThread(errorStream, this.console);
            readerThread.start();
            errorThread.start();
            int exitValue = process.waitFor();
            readerThread.interrupt();
            errorThread.interrupt();
            readerThread.join();
            errorThread.join();
            if (exitValue == 0) {
                return Status.OK_STATUS;
            }
            return new Status(4, "com.espressif.idf.core", "Error");
        }
        catch (InterruptedException e) {
            try {
                if (readerThread != null) {
                    readerThread.interrupt();
                }
                if (errorThread != null) {
                    errorThread.interrupt();
                }
                if (readerThread != null) {
                    readerThread.join();
                }
                if (errorThread != null) {
                    errorThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return new Status(4, "com.espressif.idf.core", e.getMessage(), (Throwable)e);
        }
    }
}

