/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.size;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.size.IDFSizeConstants;
import com.espressif.idf.ui.size.IDFSizeDataManager;
import com.espressif.idf.ui.size.Messages;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.util.Rotation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class IDFSizeChartsComposite {
    private ChartMode chartMode = ChartMode.STACKED_BAR;
    private MemoryUnit selectedUnit = MemoryUnit.KILOBYTES;
    private Composite chartComp;
    private JSONObject overviewJson;
    private ScrolledComposite scrollable;
    private final Map<String, Color> labelColorMap = new HashMap<String, Color>();
    private final List<Color> availableColors = new ArrayList<Color>(List.of(Color.BLUE, Color.RED, Color.ORANGE, Color.MAGENTA, Color.CYAN, Color.PINK, Color.YELLOW, Color.LIGHT_GRAY, Color.DARK_GRAY));
    private int colorIndex = 0;

    public void createPartControl(Composite parent, IFile file, String targetName) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite toolbar = new Composite(parent, 0);
        toolbar.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        toolbar.setLayout((Layout)new GridLayout(4, false));
        Label toggleLabel = new Label(toolbar, 0);
        toggleLabel.setText(Messages.IDFSizeOverviewComposite_ChartView);
        Button toggleButton = new Button(toolbar, 2);
        toggleButton.setText(Messages.IDFSizeOverviewComposite_SwitchToPie);
        Label unitLabel = new Label(toolbar, 0);
        unitLabel.setText(Messages.IDFSizeChartsComposite_SizeUnit);
        Combo unitCombo = new Combo(toolbar, 12);
        unitCombo.setItems(new String[]{"Bytes", "KB", "MB"});
        unitCombo.select(1);
        this.scrollable = new ScrolledComposite(parent, 768);
        this.scrollable.setExpandHorizontal(true);
        this.scrollable.setExpandVertical(true);
        this.scrollable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chartComp = new Composite((Composite)this.scrollable, 0);
        this.chartComp.setLayout((Layout)new GridLayout(2, false));
        this.scrollable.setContent((Control)this.chartComp);
        unitCombo.addListener(13, e -> {
            this.selectedUnit = switch (unitCombo.getSelectionIndex()) {
                case 0 -> MemoryUnit.BYTES;
                case 2 -> MemoryUnit.MEGABYTES;
                default -> MemoryUnit.KILOBYTES;
            };
            this.plotCharts();
        });
        toggleButton.addListener(13, e -> {
            this.chartMode = this.chartMode == ChartMode.STACKED_BAR ? ChartMode.PIE : ChartMode.STACKED_BAR;
            toggleButton.setText(this.chartMode == ChartMode.STACKED_BAR ? Messages.IDFSizeOverviewComposite_SwitchToPie : Messages.IDFSizeOverviewComposite_SwitchToBar);
            this.plotCharts();
        });
        this.overviewJson = this.getIDFSizeOverviewData(file, targetName);
        this.plotCharts();
    }

    private void plotCharts() {
        Control[] controlArray = this.chartComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        JSONArray layoutArray = (JSONArray)this.overviewJson.get((Object)IDFSizeConstants.LAYOUT);
        for (Object obj : layoutArray) {
            JSONObject section = (JSONObject)obj;
            String sectionName = (String)section.get((Object)IDFSizeConstants.NAME);
            long free = (Long)section.get((Object)IDFSizeConstants.FREE);
            JSONObject parts = (JSONObject)section.get((Object)"parts");
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<Long> values = new ArrayList<Long>();
            for (Object key : parts.keySet()) {
                String label = (String)key;
                JSONObject partInfo = (JSONObject)parts.get((Object)label);
                long size = (Long)partInfo.get((Object)"size");
                labels.add(label);
                values.add(size);
            }
            if (free > 0L) {
                labels.add("Free");
                values.add(free);
            }
            String title = Messages.IDFSizeOverviewComposite_MemoryUsagePrefix + sectionName;
            if (this.chartMode == ChartMode.PIE) {
                this.createPieChart(this.chartComp, title, labels, values);
                continue;
            }
            this.createBarChart(this.chartComp, title, labels, values);
        }
        this.chartComp.layout(true, true);
        this.scrollable.setMinSize(this.chartComp.computeSize(-1, -1));
    }

    private void createBarChart(Composite parent, String title, List<String> labels, List<Long> values) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int i = 0;
        while (i < labels.size()) {
            double value = (double)values.get(i).longValue() / (double)this.selectedUnit.getDivider();
            dataset.addValue(value, (Comparable)((Object)labels.get(i)), (Comparable)((Object)""));
            ++i;
        }
        JFreeChart chart = ChartFactory.createStackedBarChart((String)title, (String)Messages.IDFSizeChartsComposite_MemoryParts, (String)MessageFormat.format(Messages.IDFSizeChartsComposite_SizeTag, this.selectedUnit.getLabel()), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot categoryPlot = chart.getCategoryPlot();
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        int i2 = 0;
        while (i2 < dataset.getRowCount()) {
            String rowKey = dataset.getRowKey(i2).toString();
            if (rowKey.startsWith("Free")) {
                this.labelColorMap.putIfAbsent(rowKey, Color.GREEN);
            } else {
                this.labelColorMap.putIfAbsent(rowKey, this.getNextAvailableColor());
            }
            barRenderer.setSeriesPaint(i2, (Paint)this.labelColorMap.get(rowKey));
            ++i2;
        }
        barRenderer.setBarPainter((BarPainter)new StandardBarPainter());
        this.displayChartAsImage(parent, chart, 400, 300);
    }

    private void createPieChart(Composite parent, String title, List<String> labels, List<Long> values) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        int i = 0;
        while (i < labels.size()) {
            String label = labels.get(i) + " (" + this.formatMemory(values.get(i)) + ")";
            double value = (double)values.get(i).longValue() / (double)this.selectedUnit.getDivider();
            dataset.setValue((Comparable)((Object)label), value);
            ++i;
        }
        JFreeChart chart = ChartFactory.createPieChart((String)title, (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.8f);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlineVisible(true);
        plot.setLabelGenerator(null);
        plot.setSimpleLabels(false);
        plot.setLabelGap(0.05);
        for (String key : dataset.getKeys()) {
            if (key.startsWith("Free")) {
                this.labelColorMap.putIfAbsent(key, Color.GREEN);
            } else {
                this.labelColorMap.putIfAbsent(key, this.getNextAvailableColor());
            }
            plot.setSectionPaint((Comparable)((Object)key), (Paint)this.labelColorMap.get(key));
        }
        this.displayChartAsImage(parent, chart, 400, 400);
    }

    private Color getNextAvailableColor() {
        if (this.colorIndex >= this.availableColors.size()) {
            Color random = new Color((int)(Math.random() * 200.0), (int)(Math.random() * 200.0), (int)(Math.random() * 200.0));
            if (random.equals(Color.GREEN)) {
                return this.getNextAvailableColor();
            }
            return random;
        }
        return this.availableColors.get(this.colorIndex++);
    }

    private void displayChartAsImage(Composite parent, JFreeChart chart, int width, int height) {
        try {
            BufferedImage image = chart.createBufferedImage(width, height);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            ImageData imgData = new ImageData((InputStream)is);
            Image swtImg = new Image((Device)parent.getDisplay(), imgData);
            Label imgLabel = new Label(parent, 0);
            imgLabel.setImage(swtImg);
        }
        catch (Exception e) {
            Logger.log((Exception)e);
        }
    }

    private JSONObject getIDFSizeOverviewData(IFile file, String targetName) {
        try {
            return new IDFSizeDataManager().getIDFSizeOverview(file, targetName);
        }
        catch (Exception e) {
            Logger.log((Exception)e);
            return null;
        }
    }

    private String formatMemory(long bytes) {
        double value = (double)bytes / (double)this.selectedUnit.getDivider();
        return String.format("%.1f %s", value, this.selectedUnit.getLabel());
    }

    private static enum ChartMode {
        STACKED_BAR,
        PIE;

    }

    private static enum MemoryUnit {
        BYTES(1L, "B"),
        KILOBYTES(1024L, "KB"),
        MEGABYTES(0x100000L, "MB");

        private final long divider;
        private final String label;

        private MemoryUnit(long divider, String label) {
            this.divider = divider;
            this.label = label;
        }

        public long getDivider() {
            return this.divider;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

