/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.nvs.dialog;

import com.espressif.idf.core.build.NvsTableBean;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.NvsBeanValidator;
import com.espressif.idf.core.util.NvsPartitionGenerator;
import com.espressif.idf.core.util.NvsTableDataService;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.EclipseUtil;
import com.espressif.idf.ui.nvs.dialog.Messages;
import com.espressif.idf.ui.nvs.dialog.NvsTableEditorLabelProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class NvsEditorDialog
extends TitleAreaDialog {
    private Table csvTable;
    private TableViewer tableViewer;
    private String[] columnNames = new String[]{"Key", "Type", "Encoding", "Value"};
    private Text sizeText;
    private IFile csvFile;
    private CellEditor[] cellEditors;
    private boolean isPageValid;
    private Composite encryptionComposite;
    private Text encryptionKeyText;
    private Button generateEncryptionKeyCheckBox;
    private Button encryptAction;
    private Button generateButton;
    private String saveErrorMsg;

    public NvsEditorDialog(Shell parentShell) {
        super(parentShell);
        ErrorListenerMap.INSTANCE.setDialog(this);
    }

    public void setCsvFile(IFile csvFile) {
        this.csvFile = csvFile;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.NvsTableEditorDialog_Title);
        this.setMessage(Messages.NvsEditorDialog_DefaultMessage, 1);
        this.getShell().getLayout();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.NvsTableEditorDialog_Title);
        this.createEnctyptionLable(parent);
        this.createSizeOfPartitionLable(parent);
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(2, false));
        this.createTable((Composite)group);
        this.createToolButtonBar((Composite)group);
        this.createColumns();
        this.createTableViewer();
        return super.createDialogArea(parent);
    }

    private void createToolButtonBar(Composite parent) {
        Composite userButtonComp = new Composite(parent, 0);
        userButtonComp.setLayoutData((Object)new GridData(4, 4, false, true));
        userButtonComp.setLayout((Layout)new GridLayout());
        this.encryptAction = new Button(userButtonComp, 32);
        this.encryptAction.setText(Messages.NvsTableEditorIsEncryptedActionMsg);
        this.encryptAction.setLayoutData((Object)new GridData(4, 1, false, false));
        this.encryptAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Stream.of(NvsEditorDialog.this.encryptionComposite.getChildren()).forEach(t -> t.setEnabled(NvsEditorDialog.this.encryptAction.getSelection()));
                if (NvsEditorDialog.this.encryptAction.getSelection()) {
                    NvsEditorDialog.this.generateEncryptionKeyCheckBox.notifyListeners(13, null);
                } else {
                    ErrorListenerMap.INSTANCE.remove(GeneratePartitionValidationError.ENCRYPTION_PATH_ERROR);
                }
            }
        });
        Button addButton = new Button(userButtonComp, 8);
        addButton.setText(Messages.NvsTableEditorDialog_AddRowAction);
        addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(t -> this.getAddRowAction()));
        Button deleteRowButton = new Button(userButtonComp, 8);
        deleteRowButton.setText(Messages.NvsTableEditorDialog_DeleteSelectedAction);
        deleteRowButton.setLayoutData((Object)new GridData(4, 1, false, false));
        deleteRowButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(t -> this.getDeleteRowAction()));
        Button saveButton = new Button(userButtonComp, 8);
        saveButton.setText(Messages.NvsTableEditorDialog_SaveAction);
        saveButton.setLayoutData((Object)new GridData(4, 1, false, false));
        saveButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(t -> this.getSaveAction()));
        this.generateButton = new Button(userButtonComp, 8);
        this.generateButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.generateButton.setText(Messages.NvsTableEditorGeneratePartitionActionMsg);
        this.generateButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(t -> this.getGeneratePartitionAction()));
        this.encryptAction.notifyListeners(13, null);
        this.generateButton.setEnabled(false);
        this.setErrorMessage(null);
    }

    private void createEnctyptionLable(Composite parent) {
        this.encryptionComposite = this.encryptionComposite == null ? new Composite(parent, 0) : this.encryptionComposite;
        this.encryptionComposite.setLayout((Layout)new GridLayout(3, false));
        this.generateEncryptionKeyCheckBox = new Button(this.encryptionComposite, 32);
        this.generateEncryptionKeyCheckBox.setText(Messages.NvsEditorDialog_GenEncKeyCheckBoxTxt);
        this.generateEncryptionKeyCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        final ArrayList<Object> canBeDisposedList = new ArrayList<Object>();
        Label encyptionKeyLbl = new Label(this.encryptionComposite, 0);
        encyptionKeyLbl.setText(Messages.NvsEditorDialog_PathToEncrKeyLbl);
        encyptionKeyLbl.setLayoutData((Object)new GridData(768));
        this.encryptionKeyText = new Text(this.encryptionComposite, 2048);
        final ControlDecoration deco = new ControlDecoration((Control)this.encryptionKeyText, 131072);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.encryptionKeyText.setMessage(Messages.NvsEditorDialog_PathToKeysTxt);
        this.encryptionKeyText.setLayoutData((Object)new GridData(768));
        this.encryptionKeyText.addModifyListener(e -> {
            String errMsg = this.validateEncKeyPath();
            if (errMsg.isBlank()) {
                deco.setImage(null);
                deco.setDescriptionText(null);
                return;
            }
            deco.setDescriptionText(errMsg);
            deco.setImage(image);
        });
        Button encyptionKeyBrowseButton = new Button(this.encryptionComposite, 8);
        encyptionKeyBrowseButton.setText(Messages.NvsEditorDialog_EncKeyBrowseTxt);
        encyptionKeyBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(NvsEditorDialog.this.getShell(), 4096);
                dlg.setFilterPath(NvsEditorDialog.this.csvFile.getProject().getLocationURI().toString());
                dlg.setFilterExtensions(new String[]{"*.bin", "*"});
                dlg.setText(Messages.NvsEditorDialog_EncrPartitionKeyDlgTxt);
                String dir = dlg.open();
                if (dir != null) {
                    NvsEditorDialog.this.encryptionKeyText.setText(dir);
                    NvsEditorDialog.this.encryptionKeyText.getParent().pack();
                }
            }
        });
        encyptionKeyBrowseButton.setLayoutData((Object)new GridData(768));
        ((GridData)this.encryptionKeyText.getLayoutData()).minimumWidth = 200;
        canBeDisposedList.add(encyptionKeyLbl);
        canBeDisposedList.add(this.encryptionKeyText);
        canBeDisposedList.add(encyptionKeyBrowseButton);
        this.generateEncryptionKeyCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NvsEditorDialog.this.generateEncryptionKeyCheckBox.getSelection()) {
                    canBeDisposedList.forEach(t -> t.setEnabled(false));
                    ErrorListenerMap.INSTANCE.remove(GeneratePartitionValidationError.ENCRYPTION_PATH_ERROR);
                    deco.setImage(null);
                    return;
                }
                canBeDisposedList.forEach(t -> t.setEnabled(true));
                NvsEditorDialog.this.encryptionKeyText.notifyListeners(24, null);
            }
        });
        this.generateEncryptionKeyCheckBox.setSelection(true);
        this.generateEncryptionKeyCheckBox.notifyListeners(13, null);
        this.setErrorMessage(null);
    }

    private void createSizeOfPartitionLable(Composite parent) {
        Composite sizeComposite = new Composite(parent, 0);
        sizeComposite.setLayout((Layout)new GridLayout(2, false));
        Label sizeOfPartitionLbl = new Label(sizeComposite, 0);
        sizeOfPartitionLbl.setText(Messages.NvsTableEditorSizeOfPartitionLblMsg);
        sizeOfPartitionLbl.setLayoutData((Object)new GridData(1808));
        this.sizeText = new Text(sizeComposite, 2048);
        this.sizeText.setLayoutData((Object)new GridData(1808));
        this.sizeText.setMessage(Messages.NvsEditorDialog_DefaultSizeMsg);
        ControlDecoration deco = new ControlDecoration((Control)this.sizeText, 131072);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.sizeText.addModifyListener(e -> {
            String errMsg = this.validateSize();
            if (errMsg.isBlank()) {
                deco.setImage(null);
                deco.setDescriptionText(null);
                return;
            }
            deco.setImage(image);
            deco.setDescriptionText(errMsg);
        });
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.csvTable);
        this.tableViewer.setContentProvider((IContentProvider)((IStructuredContentProvider)input -> {
            List list = (List)input;
            return list.toArray();
        }));
        try {
            List list = new NvsTableDataService().parseCsv(Paths.get(this.csvFile.getLocationURI()));
            this.tableViewer.setInput((Object)list);
            list.forEach(bean -> this.tableViewer.update(bean, this.columnNames));
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new NvsTableEditorLabelProvider());
        this.tableViewer.setColumnProperties(this.columnNames);
        this.cellEditors = new CellEditor[4];
        this.cellEditors[0] = new TextCellEditor((Composite)this.csvTable);
        this.cellEditors[1] = new ComboBoxCellEditor((Composite)this.csvTable, NvsTableDataService.getTypes(), 8);
        this.cellEditors[2] = new ComboBoxCellEditor((Composite)this.csvTable, NvsTableDataService.getEncodings((String)""), 8);
        this.cellEditors[3] = new TextCellEditor((Composite)this.csvTable);
        this.tableViewer.setCellEditors(this.cellEditors);
        this.tableViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                int index = -1;
                int i = 0;
                while (i < NvsEditorDialog.this.columnNames.length) {
                    if (NvsEditorDialog.this.columnNames[i].equals(property)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                NvsTableBean bean = null;
                if (element instanceof Item) {
                    TableItem item = (TableItem)element;
                    bean = (NvsTableBean)item.getData();
                } else {
                    bean = (NvsTableBean)element;
                }
                switch (index) {
                    case 0: {
                        bean.setKey((String)value);
                        break;
                    }
                    case 1: {
                        String newType = NvsTableDataService.getTypes()[(Integer)value];
                        if (newType.contentEquals(bean.getType())) break;
                        bean.setType(newType);
                        ((ComboBoxCellEditor)NvsEditorDialog.this.cellEditors[2]).setItems(NvsTableDataService.getEncodings((String)bean.getType()));
                        NvsEditorDialog.this.tableViewer.getCellModifier().modify(element, NvsEditorDialog.this.columnNames[2], (Object)0);
                        break;
                    }
                    case 2: {
                        bean.setEncoding(NvsTableDataService.getEncodings((String)bean.getType())[(Integer)value]);
                        break;
                    }
                    case 3: {
                        bean.setValue((String)value);
                        break;
                    }
                }
                NvsEditorDialog.this.tableViewer.update((Object)bean, NvsEditorDialog.this.columnNames);
            }

            public Object getValue(Object element, String property) {
                int index = -1;
                int i = 0;
                while (i < NvsEditorDialog.this.columnNames.length) {
                    if (NvsEditorDialog.this.columnNames[i].equals(property)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                NvsTableBean bean = (NvsTableBean)element;
                switch (index) {
                    case 0: {
                        return bean.getKey();
                    }
                    case 1: {
                        String stringValue = bean.getType();
                        String[] choices = NvsTableDataService.getTypes();
                        int i2 = choices.length - 1;
                        while (!stringValue.equals(choices[i2]) && i2 > 0) {
                            --i2;
                        }
                        return i2;
                    }
                    case 2: {
                        ((ComboBoxCellEditor)NvsEditorDialog.this.cellEditors[2]).setItems(NvsTableDataService.getEncodings((String)bean.getType()));
                        String stringValue = bean.getEncoding();
                        String[] choices = NvsTableDataService.getEncodings((String)bean.getType());
                        int i3 = choices.length - 1;
                        while (!stringValue.equals(choices[i3]) && i3 > 0) {
                            --i3;
                        }
                        return i3;
                    }
                    case 3: {
                        return bean.getValue();
                    }
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                boolean isCellEditable;
                if (NvsEditorDialog.this.tableViewer.getElementAt(0).equals(element)) {
                    if (!property.contentEquals(NvsEditorDialog.this.columnNames[0])) {
                        NvsEditorDialog.this.setMessage(Messages.NvsEditorDialog_FirstRowIsFixedInfoMsg, 1);
                    }
                    return property.contentEquals(NvsEditorDialog.this.columnNames[0]);
                }
                NvsTableBean bean = (NvsTableBean)element;
                boolean bl = isCellEditable = !bean.getType().contentEquals("namespace") || !property.contentEquals(NvsEditorDialog.this.columnNames[2]) && !property.contentEquals(NvsEditorDialog.this.columnNames[3]);
                if (!isCellEditable) {
                    NvsEditorDialog.this.setMessage(Messages.NvsEditorDialog_NamespaceEditLimitationInfoMsg, 1);
                }
                return isCellEditable;
            }
        });
    }

    private void createColumns() {
        TableColumn keyColumn = new TableColumn(this.csvTable, 0);
        keyColumn.setText(this.columnNames[0]);
        TableColumn typeColumn = new TableColumn(this.csvTable, 0);
        typeColumn.setText(this.columnNames[1]);
        TableColumn encriptionColumn = new TableColumn(this.csvTable, 0);
        encriptionColumn.setText(this.columnNames[2]);
        TableColumn valueColumn = new TableColumn(this.csvTable, 0);
        valueColumn.setText(this.columnNames[3]);
        keyColumn.setWidth(100);
        typeColumn.setWidth(100);
        encriptionColumn.setWidth(100);
        valueColumn.setWidth(100);
    }

    private void createTable(Composite parent) {
        this.csvTable = new Table(parent, 68352);
        this.csvTable.setHeaderVisible(true);
        this.csvTable.setLinesVisible(true);
        this.csvTable.setLayoutData((Object)new GridData(4, 4, false, true));
        ((GridData)this.csvTable.getLayoutData()).widthHint = 1000;
        this.csvTable.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){
            Shell errorToolTip;

            public void mouseHover(MouseEvent event) {
                ViewerCell item = NvsEditorDialog.this.tableViewer.getCell(new Point(event.x, event.y));
                if (item != null) {
                    if (this.errorToolTip != null && !this.errorToolTip.isDisposed()) {
                        this.errorToolTip.dispose();
                    }
                    this.errorToolTip = new Shell(NvsEditorDialog.this.getShell(), 16388);
                    this.errorToolTip.setLayout((Layout)new FillLayout());
                    Label label = new Label((Composite)this.errorToolTip, 0);
                    label.setForeground(NvsEditorDialog.this.getShell().getDisplay().getSystemColor(28));
                    label.setBackground(NvsEditorDialog.this.getShell().getDisplay().getSystemColor(29));
                    label.setText(new NvsBeanValidator().validateBean((NvsTableBean)item.getElement(), item.getColumnIndex()));
                    Point size = this.errorToolTip.computeSize(-1, -1);
                    Rectangle rect = item.getBounds();
                    Point pt = NvsEditorDialog.this.csvTable.toDisplay(rect.x, rect.y);
                    this.errorToolTip.setBounds(pt.x, pt.y, size.x, size.y);
                    this.errorToolTip.setVisible(true);
                    NvsEditorDialog.this.csvTable.addMouseMoveListener(e -> this.errorToolTip.dispose());
                }
            }
        });
    }

    private void getGeneratePartitionAction() {
        String errorMsg = this.validateSize();
        errorMsg = errorMsg.isBlank() ? this.validateEncKeyPath() : errorMsg;
        String infoMsg = errorMsg.isEmpty() ? NvsPartitionGenerator.generateNvsPartititon((boolean)this.encryptAction.getSelection(), this.getEncKeyPath(), (String)this.sizeText.getText(), (IFile)this.csvFile) : errorMsg;
        this.setMessage(infoMsg, 1);
        Logger.log((String)infoMsg);
        try {
            EclipseUtil.getSelectedProjectInExplorer().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    public void setGenerationButtonStatus() {
        if (this.generateButton != null) {
            this.generateButton.setEnabled(ErrorListenerMap.INSTANCE.validationErrors.isEmpty());
        }
    }

    private String validateEncKeyPath() {
        String encKeyPath = this.getEncKeyPath().orElseGet(() -> "");
        if (this.encryptAction.getSelection() && !this.generateEncryptionKeyCheckBox.getSelection() && !new File(encKeyPath).canRead()) {
            ErrorListenerMap.INSTANCE.put(GeneratePartitionValidationError.ENCRYPTION_PATH_ERROR, Messages.NvsEditorDialog_EncKeyCantBeReadErrMsg);
            return Messages.NvsEditorDialog_EncKeyCantBeReadErrMsg;
        }
        ErrorListenerMap.INSTANCE.remove(GeneratePartitionValidationError.ENCRYPTION_PATH_ERROR);
        return "";
    }

    private String validateSize() {
        Long decodedSize = 0L;
        try {
            decodedSize = Long.decode(this.sizeText.getText());
        }
        catch (NumberFormatException e) {
            ErrorListenerMap.INSTANCE.put(GeneratePartitionValidationError.SIZE_ERROR, Messages.NvsEditorDialog_SizeValidationDecodedErr + e.getMessage());
            return Messages.NvsEditorDialog_SizeValidationDecodedErr + e.getMessage();
        }
        if (decodedSize < 4096L || decodedSize % 4096L != 0L) {
            ErrorListenerMap.INSTANCE.put(GeneratePartitionValidationError.SIZE_ERROR, Messages.NvsEditorDialog_WrongSizeFormatErrMsg);
            return Messages.NvsEditorDialog_WrongSizeFormatErrMsg;
        }
        ErrorListenerMap.INSTANCE.remove(GeneratePartitionValidationError.SIZE_ERROR);
        return "";
    }

    private Optional<String> getEncKeyPath() {
        if (!this.encryptionKeyText.isEnabled()) {
            return Optional.empty();
        }
        return Optional.of(this.encryptionKeyText.getText());
    }

    private void getSaveAction() {
        List beansToSave = (List)this.tableViewer.getInput();
        this.isPageValid = this.validateBeansBeforeSaving(beansToSave);
        this.updateErrorMessage();
        if (!this.isPageValid) {
            return;
        }
        new NvsTableDataService().saveCsv(this.csvFile, beansToSave);
        this.setMessage(Messages.NvsTableEditorDialog_SaveInfoMsg, 1);
        Logger.log((String)Messages.NvsTableEditorDialog_SaveInfoMsg);
        try {
            EclipseUtil.getSelectedProjectInExplorer().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private boolean validateBeansBeforeSaving(List<NvsTableBean> beansToSave) {
        if (beansToSave.isEmpty()) {
            this.saveErrorMsg = Messages.NvsEditorDialog_EmptyTableErrorMsg;
            return false;
        }
        if (!this.validateFirstBean(beansToSave.get(0))) {
            return false;
        }
        for (NvsTableBean bean : beansToSave) {
            int i = 0;
            while (i < this.columnNames.length) {
                String errorMsg = new NvsBeanValidator().validateBean(bean, i);
                if (!errorMsg.isBlank()) {
                    this.saveErrorMsg = errorMsg;
                    return false;
                }
                ++i;
            }
        }
        this.saveErrorMsg = "";
        return true;
    }

    private boolean validateFirstBean(NvsTableBean nvsTableBean) {
        String errorMsg = new NvsBeanValidator().validateFirstBean(nvsTableBean);
        if (!errorMsg.isBlank()) {
            this.saveErrorMsg = errorMsg;
            return false;
        }
        return true;
    }

    private void getDeleteRowAction() {
        List beansToSave = (List)this.tableViewer.getInput();
        NvsTableBean selectedElement = (NvsTableBean)this.tableViewer.getElementAt(this.csvTable.getSelectionIndex());
        if (selectedElement == null) {
            return;
        }
        if (selectedElement.equals(this.tableViewer.getElementAt(0))) {
            this.setMessage(Messages.NvsEditorDialog_FirstRowIsFixedInfoMsg, 1);
            return;
        }
        boolean confirmDelete = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.NvsTableEditorDialog_DeleteSelectedAction, (String)Messages.NvsEditorDialog_ConfirmDeleteMsg);
        if (!confirmDelete) {
            return;
        }
        beansToSave.remove(selectedElement);
        this.tableViewer.setInput((Object)beansToSave);
        this.tableViewer.refresh();
    }

    private void getAddRowAction() {
        List beansToSave = (List)this.tableViewer.getInput();
        beansToSave.add(new NvsTableBean());
        this.tableViewer.setInput((Object)beansToSave);
        this.tableViewer.refresh();
        this.csvTable.select(this.csvTable.getItemCount() - 1);
        this.tableViewer.refresh();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.NvsTableEditorSaveAndQuitButtonLable, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.getSaveAction();
        if (this.isPageValid) {
            super.okPressed();
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.NvsTableEditorDialog_SaveInfoTitle, (String)Messages.NvsTableEditorDialog_SaveInfoMsg);
        }
    }

    public void updateErrorMessage() {
        Object newErrorMessage = "";
        EnumMap<GeneratePartitionValidationError, String> validationErrors = ErrorListenerMap.INSTANCE.validationErrors;
        if (this.saveErrorMsg != null && !this.saveErrorMsg.isBlank()) {
            newErrorMessage = String.format(Messages.NvsEditorDialog_ComplexSaveErrorMsg, this.saveErrorMsg);
        }
        if (!validationErrors.isEmpty()) {
            newErrorMessage = ((String)newErrorMessage).isBlank() ? newErrorMessage : ((String)newErrorMessage).concat(StringUtil.LINE_SEPARATOR).concat(" ");
            ArrayList<String> valuesArr = new ArrayList<String>();
            for (Map.Entry<GeneratePartitionValidationError, String> errorEntry : validationErrors.entrySet()) {
                valuesArr.add(errorEntry.getValue());
            }
            newErrorMessage = (String)newErrorMessage + String.format(Messages.NvsEditorDialog_GenerateButtonComplexErrorMsg, String.join((CharSequence)"; ", valuesArr));
        }
        newErrorMessage = ((String)newErrorMessage).isBlank() ? null : newErrorMessage;
        super.setErrorMessage((String)newErrorMessage);
    }

    protected boolean isResizable() {
        return true;
    }

    private static enum ErrorListenerMap {
        INSTANCE;

        private EnumMap<GeneratePartitionValidationError, String> validationErrors = new EnumMap(GeneratePartitionValidationError.class);
        private NvsEditorDialog dialog;

        void setDialog(NvsEditorDialog dialog) {
            this.dialog = dialog;
        }

        public void put(GeneratePartitionValidationError key, String errMsg) {
            this.validationErrors.put(key, errMsg);
            this.dialog.setGenerationButtonStatus();
            this.dialog.updateErrorMessage();
        }

        public void remove(GeneratePartitionValidationError key) {
            this.validationErrors.remove((Object)key);
            this.dialog.setGenerationButtonStatus();
            this.dialog.updateErrorMessage();
        }
    }

    static enum GeneratePartitionValidationError {
        SIZE_ERROR,
        ENCRYPTION_PATH_ERROR;

    }
}

