/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.handlers;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.ui.LaunchBarListener;
import com.espressif.idf.ui.handlers.Messages;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.swt.widgets.Display;

public class RenameIdfProjectParticipant
extends RenameParticipant {
    private IProject project;

    protected boolean initialize(Object element) {
        if (element instanceof IProject) {
            IProject projectElement;
            this.project = projectElement = (IProject)element;
        }
        return true;
    }

    public String getName() {
        return null;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ILaunchBarManager launchBarManager = (ILaunchBarManager)IDFCorePlugin.getService(ILaunchBarManager.class);
        ILaunchTarget activeLaunchTarget = launchBarManager.getActiveLaunchTarget();
        LaunchBarListener.setIgnoreTargetChange(true);
        Display.getDefault().syncExec(() -> Display.getDefault().getActiveShell().addDisposeListener(disposeEvent -> {
            try {
                LaunchBarListener.setIgnoreTargetChange(false);
                launchBarManager.setActiveLaunchTarget(activeLaunchTarget);
            }
            catch (CoreException e) {
                Logger.log((Exception)((Object)e));
            }
        }));
        return new UpdateBuildFolderChange();
    }

    class UpdateBuildFolderChange
    extends Change {
        private String oldBuildFolderPath;
        private String newBuildPath;
        private IProject newProject;
        private IFolder newBuildFolder;

        UpdateBuildFolderChange() {
        }

        public String getName() {
            return String.format(Messages.RenameIdfProjectParticipant_RenameBuildFolderPathChangeName, this.oldBuildFolderPath, this.newBuildPath);
        }

        public RefactoringStatus isValid(IProgressMonitor pm) {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }

        public void initializeValidationData(IProgressMonitor pm) {
            try {
                this.oldBuildFolderPath = IDFUtil.getBuildDir((IProject)RenameIdfProjectParticipant.this.project);
                String newProjectName = RenameIdfProjectParticipant.this.getArguments().getNewName();
                this.newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newProjectName);
                this.newBuildFolder = this.newProject.getFolder("build");
                this.newBuildPath = this.newBuildFolder.getFullPath().toOSString();
            }
            catch (CoreException e) {
                Logger.log((Exception)((Object)e));
            }
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            IDFUtil.setBuildDir((IProject)this.newProject, (String)this.newBuildFolder.getLocation().toOSString());
            return null;
        }

        public Object getModifiedElement() {
            return RenameIdfProjectParticipant.this.project;
        }
    }
}

