/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.dialogs;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.ui.IDFConsole;
import com.espressif.idf.ui.update.Messages;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;

public class SbomCommandDialog
extends TitleAreaDialog {
    private static final String PATH_REGEX = "(.+)";
    private static final String DEFAULT_OUTPUT_FILE_NAME = "sbom.txt";
    private static final String ESP_IDF_SBOM_COMMAND_NAME = "esp_idf_sbom";
    protected static final String[] EXTENSIONS = new String[]{"*.json"};
    private MessageConsoleStream console;
    private Button saveOutputToFileCheckBoxButton;
    private Text outputFileText;
    private IProject selectedProject;
    private Text projectDescriptionPathText;
    private String projectDescription;
    private boolean saveOutputFileStatus;
    private String outputFilePath;

    public SbomCommandDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.SbomCommandDialog_SbomTitle);
        this.setTitle(Messages.SbomCommandDialog_SbomTitle);
        this.setMessage(Messages.SbomCommandDialog_SbomInfoMsg);
        this.setDefaults();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        this.saveOutputToFileCheckBoxButton = new Button(container, 32);
        this.saveOutputToFileCheckBoxButton.setText(Messages.SbomCommandDialog_RedirectOutputCheckBoxLbl);
        this.saveOutputToFileCheckBoxButton.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        Label projectDescriptionPathLbl = new Label(container, 0);
        projectDescriptionPathLbl.setText(Messages.SbomCommandDialog_ProjectDescriptionPathLbl);
        this.projectDescriptionPathText = new Text(container, 2308);
        this.projectDescriptionPathText.setLayoutData((Object)new GridData(768));
        Button projectDescriptionBtn = new Button(container, 8);
        projectDescriptionBtn.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        projectDescriptionBtn.setText(Messages.SbomCommandDialog_BrowseBtnTxt);
        projectDescriptionBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileSelectionDialog = new FileDialog(SbomCommandDialog.this.getParentShell());
                fileSelectionDialog.setFilterExtensions(EXTENSIONS);
                fileSelectionDialog.setFilterPath(SbomCommandDialog.this.buildProjectDescriptionPath());
                String selectedFilePath = fileSelectionDialog.open();
                if (selectedFilePath != null && !selectedFilePath.isEmpty()) {
                    SbomCommandDialog.this.projectDescriptionPathText.setText(selectedFilePath);
                }
                super.widgetSelected(e);
            }
        });
        Label outputFileLbl = new Label(container, 0);
        outputFileLbl.setText(Messages.SbomCommandDialog_OutputFilePathLbl);
        this.outputFileText = new Text(container, 0);
        this.outputFileText.setLayoutData((Object)new GridData(768));
        Button outputFileBrowseBtn = new Button(container, 8);
        outputFileBrowseBtn.setText(Messages.SbomCommandDialog_BrowseBtnTxt);
        outputFileBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileSelectionDialog = new FileDialog(SbomCommandDialog.this.getParentShell());
                fileSelectionDialog.setFilterPath(SbomCommandDialog.this.buildProjectDescriptionPath());
                String selectedFilePath = fileSelectionDialog.open();
                if (selectedFilePath != null && !selectedFilePath.isEmpty()) {
                    SbomCommandDialog.this.outputFileText.setText(selectedFilePath);
                }
                super.widgetSelected(e);
            }
        });
        this.saveOutputToFileCheckBoxButton.addListener(13, e -> {
            outputFileLbl.setVisible(this.saveOutputToFileCheckBoxButton.getSelection());
            this.outputFileText.setVisible(this.saveOutputToFileCheckBoxButton.getSelection());
            outputFileBrowseBtn.setVisible(this.saveOutputToFileCheckBoxButton.getSelection());
            container.requestLayout();
        });
        return super.createDialogArea(parent);
    }

    protected String runCommand(List<String> arguments, Path workDir, Map<String, String> env) {
        String exportCmdOp = "";
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IStatus status = processRunner.runInBackground(arguments, (IPath)workDir, env);
            if (status == null) {
                IStatus errorStatus = IDFCorePlugin.errorStatus((String)Messages.SbomCommandDialog_StatusCantBeNullErrorMsg, null);
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)errorStatus);
                return errorStatus.getMessage();
            }
            exportCmdOp = status.getMessage();
            Logger.log((String)exportCmdOp);
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
        return exportCmdOp;
    }

    protected void okPressed() {
        IConsoleManager conMan = ConsolePlugin.getDefault().getConsoleManager();
        conMan.removeConsoles((IConsole[])Stream.of(conMan.getConsoles()).filter(c -> c.getName().equals(Messages.IDFToolsHandler_ToolsManagerConsole)).toArray(IConsole[]::new));
        this.console = new IDFConsole().getConsoleStream(Messages.IDFToolsHandler_ToolsManagerConsole, null, false);
        final Job refreshJob = new Job(Messages.SbomCommandDialog_RefreshProjectJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    SbomCommandDialog.this.selectedProject.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    Logger.log((Exception)((Object)e));
                }
                return Status.OK_STATUS;
            }
        };
        Job espIdfSbomJob = new Job(Messages.SbomCommandDialog_EspIdfSbomJobName){

            protected IStatus run(IProgressMonitor monitor) {
                if (!SbomCommandDialog.this.getEspIdfSbomInstalledStatus()) {
                    SbomCommandDialog.this.installEspIdfSbom();
                }
                SbomCommandDialog.this.runEspIdfSbomCommand();
                try {
                    refreshJob.join();
                }
                catch (InterruptedException e) {
                    Logger.log((Exception)e);
                }
                return Status.OK_STATUS;
            }
        };
        this.projectDescription = this.projectDescriptionPathText.getText();
        this.saveOutputFileStatus = this.saveOutputToFileCheckBoxButton.getSelection();
        this.outputFilePath = this.outputFileText.getText();
        espIdfSbomJob.schedule();
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    private void setDefaults() {
        IStructuredSelection element;
        Object object;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && (object = (element = (IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            IResource resource = (IResource)object;
            this.selectedProject = resource.getProject();
        }
        this.projectDescriptionPathText.setText(this.buildProjectDescriptionPath());
        if (!Files.isRegularFile(Paths.get(this.projectDescriptionPathText.getText(), new String[0]), new LinkOption[0])) {
            this.setMessage(Messages.SbomCommandDialog_ProjectDescDoesntExistDefaultErrorMsg);
            this.getButton(0).setEnabled(false);
        }
        this.outputFileText.setText(String.join((CharSequence)FileSystems.getDefault().getSeparator(), Paths.get(this.selectedProject.getLocationURI()).toString(), DEFAULT_OUTPUT_FILE_NAME));
        this.saveOutputToFileCheckBoxButton.setSelection(false);
        this.saveOutputToFileCheckBoxButton.notifyListeners(13, null);
        this.outputFileText.addListener(24, e -> this.getButton(0).setEnabled(this.validateInput()));
        this.projectDescriptionPathText.addListener(24, e -> this.getButton(0).setEnabled(this.validateInput()));
    }

    private String buildProjectDescriptionPath() {
        return String.join((CharSequence)FileSystems.getDefault().getSeparator(), Paths.get(this.selectedProject.getLocationURI()).toString(), "build", "project_description.json");
    }

    private void runEspIdfSbomCommand() {
        String cmdOutput;
        HashMap<String, String> environment = new HashMap<String, String>(IDFUtil.getSystemEnv());
        ArrayList<String> arguments = new ArrayList<String>();
        String pythonEnvPath = IDFUtil.getIDFPythonEnvPath();
        arguments.add(pythonEnvPath);
        arguments.add("-m");
        arguments.add(ESP_IDF_SBOM_COMMAND_NAME);
        arguments.add("create");
        arguments.add(this.projectDescription);
        if (this.saveOutputFileStatus) {
            arguments.add("--output-file");
            arguments.add(this.outputFilePath);
        }
        cmdOutput = (cmdOutput = this.runCommand(arguments, null, environment)).isEmpty() && this.saveOutputFileStatus ? String.format(Messages.SbomCommandDialog_ConsoleRedirectedOutputFormatString, this.outputFilePath) : cmdOutput;
        this.console.getConsole().addPatternMatchListener(this.getPatternMatchListener());
        this.console.println(cmdOutput);
    }

    private IPatternMatchListener getPatternMatchListener() {
        return new IPatternMatchListener(){

            public void matchFound(PatternMatchEvent event) {
                try {
                    IHyperlink hepHyperlink = this.createHyperlinkWhichOpensFileInEditor();
                    SbomCommandDialog.this.console.getConsole().addHyperlink(hepHyperlink, this.getPattern().length() - SbomCommandDialog.PATH_REGEX.length(), event.getLength() - this.getPattern().length() + SbomCommandDialog.PATH_REGEX.length());
                }
                catch (BadLocationException e) {
                    Logger.log((Exception)((Object)e));
                }
            }

            private IHyperlink createHyperlinkWhichOpensFileInEditor() {
                return new IHyperlink(){

                    public void linkActivated() {
                        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path((this).SbomCommandDialog.this.outputFilePath));
                        if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            try {
                                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                            }
                            catch (PartInitException e) {
                                Logger.log((Exception)((Object)e));
                            }
                        }
                    }

                    public void linkEntered() {
                    }

                    public void linkExited() {
                    }
                };
            }

            public void disconnect() {
            }

            public void connect(TextConsole console) {
            }

            public String getPattern() {
                return String.format(Messages.SbomCommandDialog_ConsoleRedirectedOutputFormatString, SbomCommandDialog.PATH_REGEX);
            }

            public String getLineQualifier() {
                return null;
            }

            public int getCompilerFlags() {
                return 0;
            }
        };
    }

    private boolean validateInput() {
        boolean validateStatus = true;
        java.nio.file.Path projectDescriptionPath = null;
        try {
            projectDescriptionPath = Paths.get(this.projectDescriptionPathText.getText(), new String[0]);
        }
        catch (InvalidPathException e) {
            validateStatus = false;
            this.setErrorMessage(Messages.SbomCommandDialog_InvalidProjectDescPathErrorMsg);
        }
        if (projectDescriptionPath != null && !Files.isRegularFile(projectDescriptionPath, new LinkOption[0])) {
            validateStatus = false;
            this.setErrorMessage(Messages.SbomCommandDialog_ProjectDescDoesntExistsErrorMsg);
        }
        java.nio.file.Path outputFilePath = null;
        try {
            outputFilePath = Paths.get(this.outputFileText.getText(), new String[0]);
        }
        catch (InvalidPathException e) {
            validateStatus = false;
            this.setErrorMessage(Messages.SbomCommandDialog_InvalidOutputFilePathErrorMsg);
        }
        if (outputFilePath != null && this.saveOutputToFileCheckBoxButton.getSelection() && this.checkIfFileIsNotWritable(outputFilePath)) {
            validateStatus = false;
            this.setErrorMessage(Messages.SbomCommandDialog_OutputFileNotWritabbleErrorMsg);
        }
        if (validateStatus) {
            this.setErrorMessage(null);
        }
        return validateStatus;
    }

    private boolean checkIfFileIsNotWritable(java.nio.file.Path pathToFile) {
        return Files.exists(pathToFile, new LinkOption[0]) && !Files.isWritable(pathToFile);
    }

    private void installEspIdfSbom() {
        HashMap<String, String> environment = new HashMap<String, String>(IDFUtil.getSystemEnv());
        ArrayList<String> arguments = new ArrayList<String>();
        String pythonEnvPath = IDFUtil.getIDFPythonEnvPath();
        arguments.add(pythonEnvPath);
        arguments.add("-m");
        arguments.add("pip");
        arguments.add("install");
        arguments.add(ESP_IDF_SBOM_COMMAND_NAME);
        String cmdOutput = this.runCommand(arguments, null, environment);
        this.console.println(cmdOutput);
    }

    private boolean getEspIdfSbomInstalledStatus() {
        HashMap<String, String> environment = new HashMap<String, String>(IDFUtil.getSystemEnv());
        ArrayList<String> arguments = new ArrayList<String>();
        String pythonEnvPath = IDFUtil.getIDFPythonEnvPath();
        arguments.add(pythonEnvPath);
        arguments.add("-m");
        arguments.add("pip");
        arguments.add("list");
        String cmdOutput = this.runCommand(arguments, null, environment);
        return cmdOutput.contains("esp-idf-sbom");
    }
}

