/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.launch.serial.internal;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.DfuCommandsUtil;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.RecheckConfigsHelper;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.launch.serial.internal.Messages;
import com.espressif.idf.launch.serial.internal.SerialFlashLaunch;
import com.espressif.idf.launch.serial.util.ESPFlashUtil;
import com.espressif.idf.terminal.connector.serial.launcher.SerialLauncherDelegate;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.debug.core.launch.CoreBuildGenericLaunchConfigDelegate;
import org.eclipse.cdt.debug.core.launch.NullProcess;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.launch.ITargetedLaunch;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.target.ILaunchTargetUIManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.WorkbenchEncoding;

public class SerialFlashLaunchConfigDelegate
extends CoreBuildGenericLaunchConfigDelegate {
    private String serialPort;

    public ITargetedLaunch getLaunch(ILaunchConfiguration configuration, String mode, ILaunchTarget target) throws CoreException {
        if (target == null) {
            ILaunchBarManager barManager = (ILaunchBarManager)IDFCorePlugin.getService(ILaunchBarManager.class);
            target = barManager.getActiveLaunchTarget();
        }
        return new SerialFlashLaunch(configuration, mode, null, target);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ((SerialFlashLaunch)launch).start();
        this.serialPort = ((ITargetedLaunch)launch).getLaunchTarget().getAttribute("com.espressif.idf.launch.serial.core.serialPort", "");
        if (DfuCommandsUtil.isDfu()) {
            if (DfuCommandsUtil.isTargetSupportDfu((ILaunchTarget)((ITargetedLaunch)launch).getLaunchTarget())) {
                DfuCommandsUtil.flashDfuBins((ILaunchConfiguration)configuration, (IProject)SerialFlashLaunchConfigDelegate.getProject((ILaunchConfiguration)configuration), (ILaunch)launch);
            }
            return;
        }
        if (ESPFlashUtil.isJtag()) {
            ESPFlashUtil.flashOverJtag(configuration, launch);
            return;
        }
        this.launchInternal(configuration, mode, launch, monitor);
    }

    protected void launchInternal(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File workingDir;
        String workingDirectory;
        IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
        String location = configuration.getAttribute("org.eclipse.cdt.launch.ATTR_LOCATION", IDFUtil.getIDFPythonEnvPath());
        if (StringUtil.isEmpty((String)(location = varManager.performStringSubstitution(location)))) {
            launch.addProcess((IProcess)new NullProcess(launch, org.eclipse.cdt.debug.internal.core.Messages.CoreBuildGenericLaunchConfigDelegate_NoAction));
            return;
        }
        String substLocation = varManager.performStringSubstitution(location);
        if (substLocation.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.core", String.format(org.eclipse.cdt.debug.internal.core.Messages.CoreBuildGenericLaunchConfigDelegate_SubstitutionFailed, location)));
        }
        location = substLocation;
        if (!new File(location).canExecute()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.core", String.format(org.eclipse.cdt.debug.internal.core.Messages.CoreBuildGenericLaunchConfigDelegate_CommandNotValid, location)));
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(location);
        String espFlashCommand = ESPFlashUtil.getEspFlashCommand(this.serialPort);
        Logger.log((String)espFlashCommand);
        if (this.checkIfPortIsEmpty(configuration)) {
            return;
        }
        String args = configuration.getAttribute("com.espressif.idf.launch.serial.core.serialFlashArguments", espFlashCommand);
        if (!args.isEmpty()) {
            args = varManager.performStringSubstitution(args);
            String[] arguments = CommandLineUtil.argumentsToArray((String)args);
            commands.addAll(Arrays.asList(arguments));
        }
        if ((workingDirectory = configuration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", "")).isEmpty()) {
            workingDir = new File(SerialFlashLaunchConfigDelegate.getProject((ILaunchConfiguration)configuration).getLocationURI());
        } else {
            workingDir = new File(varManager.performStringSubstitution(workingDirectory));
            if (!workingDir.isDirectory()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.core", String.format(org.eclipse.cdt.debug.internal.core.Messages.CoreBuildGenericLaunchConfigDelegate_WorkingDirNotExists, location)));
            }
        }
        Map envMap = new IDFEnvironmentVariables().getSystemEnvMap();
        if (envMap.containsKey("PATH") && envMap.containsKey("Path")) {
            envMap.remove("Path");
        }
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        for (Map.Entry entry : envMap.entrySet()) {
            StringBuilder buffer = new StringBuilder((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        Logger.log((String)String.format("flash command: %s", String.join((CharSequence)" ", commands)));
        String[] envArray = strings.toArray(new String[strings.size()]);
        Process p = DebugPlugin.exec((String[])commands.toArray(new String[0]), (File)workingDir, (String[])envArray);
        DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)String.join((CharSequence)" ", commands));
        p.onExit().thenAcceptAsync(process -> {
            if (process.exitValue() == 0) {
                try {
                    if (configuration.getAttribute("OPEN_SERIAL_MONITOR", true)) {
                        this.openSerialMonitor(configuration);
                    }
                }
                catch (CoreException e) {
                    Logger.log((Exception)((Object)e));
                }
            }
        }, CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS));
    }

    private void openSerialMonitor(ILaunchConfiguration configuration) throws CoreException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("delegateId", "com.espressif.idf.terminal.connector.serial.launcher.serial");
        map.put("cdtserial.portName", this.serialPort);
        map.put("idf.monitor.project", configuration.getMappedResources()[0].getName());
        map.put("encoding", configuration.getAttribute("SERIAL_MONITOR_ENCODING", WorkbenchEncoding.getWorkbenchDefaultEncoding()));
        map.put("terminal.forceNew", Boolean.FALSE);
        map.put("idf.monitor.encryption", IDFUtil.isFlashEncrypted());
        new SerialLauncherDelegate().execute(map, null);
    }

    private boolean checkIfPortIsEmpty(ILaunchConfiguration configuration) {
        boolean isMatch = false;
        try {
            String[] ports;
            String[] stringArray = ports = SerialPort.list();
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                String port = stringArray[n2];
                if (port.equals(this.serialPort)) {
                    isMatch = true;
                    break;
                }
                ++n2;
            }
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
        if (!isMatch) {
            SerialFlashLaunchConfigDelegate.showMessage(configuration);
            return true;
        }
        return false;
    }

    private static void showMessage(ILaunchConfiguration configuration) {
        Display.getDefault().asyncExec(() -> {
            boolean isYes = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.SerialPortNotFoundTitle, (String)Messages.SerialPortNotFoundMsg);
            if (isYes) {
                ILaunchTargetUIManager targetUIManager = (ILaunchTargetUIManager)Activator.getService(ILaunchTargetUIManager.class);
                ILaunchTargetManager launchTargetManager = (ILaunchTargetManager)Activator.getService(ILaunchTargetManager.class);
                targetUIManager.editLaunchTarget(launchTargetManager.getDefaultLaunchTarget(configuration));
            }
        });
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, ILaunchTarget target, IProgressMonitor monitor) throws CoreException {
        IProject project = SerialFlashLaunchConfigDelegate.getProject((ILaunchConfiguration)configuration);
        RecheckConfigsHelper.revalidateToolchain((IProject)project);
        return this.superBuildForLaunch(configuration, mode, monitor);
    }
}

