/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.launch.serial.core;

import com.espressif.idf.core.IDFProjectNature;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.launch.serial.core.IDFProjectLaunchDescriptor;
import com.espressif.idf.ui.EclipseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.ILaunchDescriptorType;
import org.eclipse.swt.widgets.Display;

public class IDFLaunchDescriptorType
implements ILaunchDescriptorType {
    private Map<ILaunchConfiguration, ILaunchDescriptor> descriptors = new HashMap<ILaunchConfiguration, ILaunchDescriptor>();

    public ILaunchDescriptor getDescriptor(Object launchObject) throws CoreException {
        if (launchObject instanceof IProject) {
            IProject project = (IProject)launchObject;
            if (launchObject instanceof IProject && IDFProjectNature.hasNature((IProject)((IProject)launchObject))) {
                return new IDFProjectLaunchDescriptor(this, project, null);
            }
        } else if (launchObject instanceof ILaunchConfiguration) {
            ILaunchConfiguration config = (ILaunchConfiguration)launchObject;
            String identifier = config.getType().getIdentifier();
            if (identifier.equals("com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationType")) {
                return null;
            }
            IProject project = this.getProject();
            if (project == null && config.getMappedResources() == null) {
                return null;
            }
            project = project != null ? project : config.getMappedResources()[0].getProject();
            try {
                if (IDFProjectNature.hasNature((IProject)project)) {
                    ILaunchDescriptor descriptor = this.descriptors.get(config);
                    if (descriptor == null) {
                        descriptor = new IDFProjectLaunchDescriptor(this, project, (ILaunchConfiguration)launchObject);
                        this.descriptors.put(config, descriptor);
                    }
                    return descriptor;
                }
            }
            catch (CoreException ce) {
                Logger.log((Exception)((Object)ce));
            }
        }
        return null;
    }

    protected IProject getProject() {
        final ArrayList projectList = new ArrayList(1);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IProject project = EclipseUtil.getSelectedProjectInExplorer();
                projectList.add(project);
            }
        });
        IProject project = (IProject)projectList.get(0);
        return project;
    }
}

