/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.sdk.config.core.server;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.sdk.config.core.SDKConfigCorePlugin;
import com.espressif.idf.sdk.config.core.server.CommandType;
import com.espressif.idf.sdk.config.core.server.IJsonConfigOutput;
import com.espressif.idf.sdk.config.core.server.IMessageHandlerListener;
import com.espressif.idf.sdk.config.core.server.IMessagesHandlerNotifier;
import com.espressif.idf.sdk.config.core.server.JsonConfigOutput;
import com.espressif.idf.sdk.config.core.server.JsonConfigServerRunnable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.console.MessageConsoleStream;
import org.json.simple.parser.ParseException;

public class JsonConfigServer
implements IMessagesHandlerNotifier {
    protected MessageConsoleStream console;
    private List<IMessageHandlerListener> listeners;
    private IProject project;
    private JsonConfigServerRunnable runnable;
    private JsonConfigOutput configOutput;
    private Process process;
    private IFile file;

    public JsonConfigServer(IProject project, IFile file) {
        this.project = project;
        this.listeners = new ArrayList<IMessageHandlerListener>();
        this.configOutput = new JsonConfigOutput();
        this.file = file;
    }

    @Override
    public void addListener(IMessageHandlerListener listener) {
        this.listeners.add(listener);
    }

    public void destroy() {
        if (this.runnable != null) {
            this.runnable.destory();
        }
    }

    public void execute(String command, CommandType type) {
        if (this.runnable != null) {
            this.runnable.executeCommand(command, type);
        }
    }

    @Override
    public void notifyHandler(String message, CommandType type) {
        for (IMessageHandlerListener listener : this.listeners) {
            listener.notifyRequestServed(message, type);
        }
    }

    @Override
    public void removeListener(IMessageHandlerListener listener) {
        this.listeners.remove(listener);
    }

    public void start() throws IOException {
        IPath workingDir = this.project.getLocation();
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        this.prepEnvMap(env);
        ArrayList<String> arguments = new ArrayList<String>();
        File idfPythonScriptFile = IDFUtil.getIDFPythonScriptFile();
        if (!idfPythonScriptFile.exists()) {
            throw new FileNotFoundException("File Not found:" + String.valueOf(idfPythonScriptFile));
        }
        try {
            String pythonPath = IDFUtil.getIDFPythonEnvPath();
            arguments.add(pythonPath);
            arguments.add(idfPythonScriptFile.getAbsolutePath());
            arguments.add("-B");
            arguments.add(IDFUtil.getBuildDir((IProject)this.project));
            arguments.add("-DSDKCONFIG=".concat(this.file.getName()));
            arguments.add("confserver");
            Logger.log((String)((Object)arguments).toString());
            ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
            String oldSdkconfigValue = "";
            oldSdkconfigValue = this.getCmakeCacheSdkconfigValue();
            this.process = processRunner.run(arguments, workingDir, env);
            this.runnable = new JsonConfigServerRunnable(this.process, this, this.project, oldSdkconfigValue);
            Thread t = new Thread(this.runnable);
            t.start();
        }
        catch (Exception e) {
            Logger.log((Exception)e);
        }
    }

    private void prepEnvMap(Map<String, String> env) {
        env.put("PYTHONUNBUFFERED", "1");
        env.put("IDF_CCACHE_ENABLE", "false");
        this.loadIdfPathWithSystemPath(env);
    }

    private void loadIdfPathWithSystemPath(Map<String, String> systemEnv) {
        IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
        String idfExportPath = idfEnvironmentVariables.getEnvValue("PATH");
        String pathVar = "PATH";
        String pathEntry = systemEnv.get(pathVar);
        if (pathEntry == null && (pathEntry = systemEnv.get(pathVar = "Path")) == null) {
            Logger.log((Exception)new Exception("No PATH found in the system environment variables"));
        }
        if (!StringUtil.isEmpty((String)pathEntry)) {
            idfExportPath = idfExportPath.replace("$PATH", pathEntry);
            idfExportPath = idfExportPath.replace("%PATH%", pathEntry);
        }
        systemEnv.put(pathVar, idfExportPath);
        for (Map.Entry entry : idfEnvironmentVariables.getEnvMap().entrySet()) {
            if (((String)entry.getKey()).equals("PATH")) continue;
            systemEnv.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private String getCmakeCacheSdkconfigValue() throws CoreException {
        File cmakeCacheFile = new File(IDFUtil.getBuildDir((IProject)this.project).concat("/CMakeCache.txt"));
        if (cmakeCacheFile.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(cmakeCacheFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith("SDKCONFIG:UNINITIALIZED=")) continue;
                        return line;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }
        return "";
    }

    public IJsonConfigOutput getOutput(String response, boolean isUpdate) {
        try {
            this.configOutput.parse(response, isUpdate);
        }
        catch (ParseException e) {
            Logger.log((Plugin)SDKConfigCorePlugin.getPlugin(), (Exception)((Object)e));
        }
        return this.configOutput;
    }

    public IJsonConfigOutput getOutput() {
        return this.configOutput;
    }

    public void addConsole(MessageConsoleStream console) {
        this.console = console;
    }

    public boolean isAlive() {
        return this.runnable.isAlive(this.process);
    }
}

