/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.sdk.config.core.server;

import com.espressif.idf.sdk.config.core.server.JsonConfigServer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class ConfigServerManager {
    public static ConfigServerManager INSTANCE = new ConfigServerManager();
    private Map<ProjectFileMapKey, JsonConfigServer> jsonServermap = new HashMap<ProjectFileMapKey, JsonConfigServer>();

    public void clearAll() {
        this.jsonServermap.clear();
    }

    public void deleteServer(IProject project, IFile file) {
        ProjectFileMapKey projectFileMapKey = new ProjectFileMapKey(project, file);
        this.jsonServermap.remove(projectFileMapKey);
    }

    public synchronized JsonConfigServer getServer(IProject project, IFile file) throws IOException {
        ProjectFileMapKey projectFileMapKey = new ProjectFileMapKey(project, file);
        JsonConfigServer jsonConfigServer = this.jsonServermap.get(projectFileMapKey);
        if (jsonConfigServer == null) {
            jsonConfigServer = new JsonConfigServer(project, file);
            this.jsonServermap.put(projectFileMapKey, jsonConfigServer);
            jsonConfigServer.start();
            return jsonConfigServer;
        }
        return jsonConfigServer;
    }

    private class ProjectFileMapKey {
        private IProject project;
        private IFile file;

        private ProjectFileMapKey(IProject project, IFile file) {
            this.file = file;
            this.project = project;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectFileMapKey that = (ProjectFileMapKey)o;
            return this.project.getName().equals(that.project.getName()) && this.file.getLocation().equals((Object)that.file.getLocation());
        }

        public int hashCode() {
            return Objects.hash(this.project.getName(), this.file.getLocation());
        }
    }
}

