/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.sdk.config.core.server;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.sdk.config.core.SDKConfigCorePlugin;
import com.espressif.idf.sdk.config.core.server.IJsonConfigOutput;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonConfigOutput
implements IJsonConfigOutput {
    private JSONObject valuesJsonMap;
    private JSONObject visibleJsonMap;
    private JSONObject rangesJsonMap;

    @Override
    public JSONObject getValuesJsonMap() {
        return this.valuesJsonMap;
    }

    @Override
    public JSONObject getVisibleJsonMap() {
        return this.visibleJsonMap;
    }

    @Override
    public JSONObject getRangesJsonMap() {
        return this.rangesJsonMap;
    }

    public void parse(String response, boolean isUpdate) throws ParseException {
        if (StringUtil.isEmpty((String)response)) {
            Logger.log((Plugin)SDKConfigCorePlugin.getPlugin(), (String)"Can't parse. Config server response can't be null or empty!");
            return;
        }
        JSONParser parser = new JSONParser();
        JSONObject jsonObj = (JSONObject)parser.parse(response);
        if (jsonObj != null) {
            if (isUpdate) {
                JSONObject visibleJson = (JSONObject)jsonObj.get((Object)"visible");
                JSONObject valuesJson = (JSONObject)jsonObj.get((Object)"values");
                JSONObject rangesJson = (JSONObject)jsonObj.get((Object)"ranges");
                Set newVisibleKeyset = visibleJson.keySet();
                for (String key : newVisibleKeyset) {
                    this.visibleJsonMap.put((Object)key, visibleJson.get((Object)key));
                }
                Set newValuesKeyset = valuesJson.keySet();
                for (String key : newValuesKeyset) {
                    this.valuesJsonMap.put((Object)key, valuesJson.get((Object)key));
                }
                Set newRangesKeyset = rangesJson.keySet();
                for (String key : newRangesKeyset) {
                    this.rangesJsonMap.put((Object)key, rangesJson.get((Object)key));
                }
            } else {
                this.valuesJsonMap = (JSONObject)jsonObj.get((Object)"values");
                this.visibleJsonMap = (JSONObject)jsonObj.get((Object)"visible");
                this.rangesJsonMap = (JSONObject)jsonObj.get((Object)"ranges");
            }
        }
    }
}

