/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.dsf;

import java.util.stream.Stream;

public enum IdfHardwareWatchpoints {
    ESP32(2),
    ESP32S2(2),
    ESP32S3(2),
    ESP32C2(2),
    ESP32C3(8),
    ESP32C6(4),
    ESP32H2(8);

    private int hardwareWatchpointNum;
    private static final int DEFAULT_WATCHPOINT_NUM = 2;

    public static int getWatchpointNumForTarget(String idfTarget) {
        String idfTargetUprCase = idfTarget.toUpperCase();
        boolean isValueExists = Stream.of(IdfHardwareWatchpoints.values()).anyMatch(x -> x.name().contentEquals(idfTargetUprCase));
        return isValueExists ? IdfHardwareWatchpoints.valueOf((String)idfTargetUprCase).hardwareWatchpointNum : 2;
    }

    private IdfHardwareWatchpoints(int num) {
        this.hardwareWatchpointNum = num;
    }
}

