/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.debug.gdbjtag.openocd.Activator;
import com.espressif.idf.debug.gdbjtag.openocd.ui.TabSvdTarget;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.launchbar.core.ILaunchBarManager;

public class SvdPathResolver
implements IDynamicVariableResolver {
    private static final ILaunchBarManager LAUNCH_BAR_MANAGER = Activator.getService(ILaunchBarManager.class);

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        String selectedTargetPath;
        String selectedTarget;
        block3: {
            selectedTarget = "";
            selectedTargetPath = "";
            selectedTarget = LAUNCH_BAR_MANAGER.getActiveLaunchTarget().getAttribute("com.espressif.idf.launch.serial.core.idfTarget", "");
            if (!StringUtil.isEmpty((String)selectedTarget)) break block3;
            return "";
        }
        try {
            selectedTargetPath = this.resolveSvdPath(selectedTarget);
        }
        catch (Exception e) {
            Logger.log((Exception)e);
        }
        return selectedTargetPath;
    }

    private String resolveSvdPath(String target) throws Exception {
        URL svdUrl = Platform.getBundle((String)"com.espressif.idf.debug.gdbjtag.openocd").getResource("svd/".concat(target.concat(".svd")));
        String jarPath = new File(TabSvdTarget.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getAbsolutePath();
        if (svdUrl == null) {
            Logger.log((String)"svd file is missing");
            return "";
        }
        String selectedTargetPath = !jarPath.contains(".jar") ? new File(FileLocator.resolve((URL)svdUrl).getPath()).getAbsolutePath() : this.resolveSvdPathFromJar(svdUrl, jarPath);
        return selectedTargetPath;
    }

    private String resolveSvdPathFromJar(URL svdUrl, String jarPath) throws Exception {
        IFile svdFile;
        IProject project = EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)LAUNCH_BAR_MANAGER.getActiveLaunchConfiguration());
        IFolder svdFolder = project.getFolder("build").getFolder("svd");
        if (!svdFolder.exists()) {
            svdFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(svdFile = project.getFolder("build").getFile(svdUrl.getPath())).exists()) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (JarFile jarFile = new JarFile(jarPath);){
                JarEntry file = (JarEntry)jarFile.getEntry(svdUrl.getFile().substring(1));
                if (file != null) {
                    InputStream inputStream = jarFile.getInputStream(file);
                    svdFile.create(inputStream, true, (IProgressMonitor)new NullProgressMonitor());
                    inputStream.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        return svdFile.getRawLocation().toOSString();
    }
}

