/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal.dialog;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class HtmlDialog
extends MessageDialog {
    protected Browser b;
    private LocationListener listener;
    private final String html;

    public HtmlDialog(String title, String message, String html) {
        super(Display.getCurrent().getActiveShell(), title, null, message, 0, new String[]{XViewerText.get("button.ok"), XViewerText.get("button.cancel")}, 0);
        this.html = html;
    }

    public void addLocationListener(LocationListener listener) {
        this.listener = listener;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.b = new Browser(c, 2048);
        GridData gd = new GridData(1808);
        this.b.setLayoutData((Object)gd);
        this.b.setText(this.html);
        this.b.setSize(500, 500);
        if (this.listener != null) {
            this.b.addLocationListener(this.listener);
        }
        this.b.setMenu(this.pageOverviewGetPopup());
        return c;
    }

    public Menu pageOverviewGetPopup() {
        Menu menu = new Menu((Control)this.b.getShell());
        MenuItem item = new MenuItem(menu, 0);
        item.setText(XViewerText.get("HtmlDialog.menu.view_source"));
        item.addListener(13, e -> {
            String file = System.getProperty("user.home") + File.separator + "out.html";
            try {
                XViewerLib.writeStringToFile(this.html, new File(file));
            }
            catch (IOException ex) {
                XViewerLog.logAndPopup(Activator.class, Level.SEVERE, ex);
            }
            Program.launch((String)file);
        });
        return menu;
    }
}

