/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.util.IDFUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EspToolCommands {
    private Process chipInfoProcess;
    private Process flashEraseProcess;
    private Process writeFlashProcess;

    public Process chipInformation(String port) throws Exception {
        this.destroyAnyChipInfoProcess();
        ProcessBuilder processBuilder = new ProcessBuilder(this.getChipInfoCommand(port));
        processBuilder.environment().putAll(IDFUtil.getSystemEnv());
        this.chipInfoProcess = processBuilder.start();
        return this.chipInfoProcess;
    }

    public Process eraseFlash(String port) throws Exception {
        this.destroyAnyChipInfoProcess();
        ProcessBuilder processBuilder = new ProcessBuilder(this.getFlashEraseCommand(port));
        processBuilder.environment().putAll(IDFUtil.getSystemEnv());
        this.flashEraseProcess = processBuilder.start();
        return this.flashEraseProcess;
    }

    public Process writeFlash(String port, String path, String offset) throws IOException {
        this.destroyAnyChipInfoProcess();
        ProcessBuilder processBuilder = new ProcessBuilder(this.getWriteFlashCommand(port, path, offset));
        processBuilder.environment().putAll(IDFUtil.getSystemEnv());
        this.writeFlashProcess = processBuilder.start();
        return this.writeFlashProcess;
    }

    private List<String> getWriteFlashCommand(String port, String path, String offset) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(IDFUtil.getIDFPythonEnvPath());
        command.add(IDFUtil.getEspToolScriptFile().getAbsolutePath());
        command.add("-p");
        command.add(port);
        command.add("write_flash");
        command.add(offset);
        command.add(path);
        return command;
    }

    private List<String> getChipInfoCommand(String port) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(IDFUtil.getIDFPythonEnvPath());
        command.add(IDFUtil.getEspToolScriptFile().getAbsolutePath());
        command.add("-p");
        command.add(port);
        command.add("chip_id");
        return command;
    }

    private List<String> getFlashEraseCommand(String port) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(IDFUtil.getIDFPythonEnvPath());
        command.add(IDFUtil.getEspToolScriptFile().getAbsolutePath());
        command.add("-p");
        command.add(port);
        command.add("erase_flash");
        return command;
    }

    private void destroyAnyChipInfoProcess() {
        if (this.chipInfoProcess != null && this.chipInfoProcess.isAlive()) {
            this.chipInfoProcess.destroy();
        }
    }

    public boolean checkActiveFlashEraseProcess() {
        if (this.flashEraseProcess != null) {
            return this.flashEraseProcess.isAlive();
        }
        return false;
    }

    public void killEraseFlashProcess() {
        if (this.flashEraseProcess != null) {
            this.flashEraseProcess.destroy();
        }
    }

    public boolean checkActiveWriteFlashProcess() {
        if (this.writeFlashProcess != null) {
            return this.writeFlashProcess.isAlive();
        }
        return false;
    }

    public void killWriteFlashProcess() {
        if (this.writeFlashProcess != null) {
            this.writeFlashProcess.destroy();
        }
    }
}

