/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;

public class IDFEnvironmentVariables {
    public static final String IDF_PATH = "IDF_PATH";
    public static final String IDF_PYTHON_ENV_PATH = "IDF_PYTHON_ENV_PATH";
    public static final String PATH = "PATH";
    public static final String OPENOCD_SCRIPTS = "OPENOCD_SCRIPTS";
    public static final String IDF_COMPONENT_MANAGER = "IDF_COMPONENT_MANAGER";
    public static final String ESP_IDF_VERSION = "ESP_IDF_VERSION";
    public static final String GIT_PATH = "GIT_PATH";
    public static final String PYTHON_EXE_PATH = "PYTHON_EXE_PATH";
    public static final String IDF_MAINTAINER = "IDF_MAINTAINER";
    public static final String IDF_CCACHE_ENABLE = "IDF_CCACHE_ENABLE";

    public IEnvironmentVariable getEnv(String variableName) {
        IContributedEnvironment contributedEnvironment = this.getEnvironment();
        IEnvironmentVariable variable = contributedEnvironment.getVariable(variableName, null);
        return variable;
    }

    public void removeEnvVariable(String variableName) {
        IContributedEnvironment contributedEnvironment = this.getEnvironment();
        contributedEnvironment.removeVariable(variableName, null);
    }

    public void removeAllEnvVariables() {
        Map<String, String> currentVarMap = this.getEnvMap();
        for (Map.Entry<String, String> varEntry : currentVarMap.entrySet()) {
            this.removeEnvVariable(varEntry.getKey());
        }
    }

    protected IContributedEnvironment getEnvironment() {
        IEnvironmentVariableManager buildEnvironmentManager = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IContributedEnvironment contributedEnvironment = buildEnvironmentManager.getContributedEnvironment();
        return contributedEnvironment;
    }

    public String getEnvValue(String variableName) {
        IEnvironmentVariable variable = this.getEnv(variableName);
        String envValue = "";
        if (variable != null) {
            envValue = variable.getValue();
        }
        return envValue;
    }

    public void addEnvVariable(String name, String value) {
        Logger.log(MessageFormat.format("Updating environment variables with key:{0} value:{1}", name, value));
        IContributedEnvironment contributedEnvironment = this.getEnvironment();
        contributedEnvironment.addVariable(name, value, 1, null, null);
        EnvironmentVariableManager.fUserSupplier.storeWorkspaceEnvironment(true);
    }

    public void prependEnvVariableValue(String variableName, String value) {
        Logger.log(MessageFormat.format("Prepending environment variables with key:{0} to value:{1}", variableName, value));
        EnvironmentVariableManager.fUserSupplier.createOverrideVariable(variableName, value, 3, EnvironmentVariableManager.getDefault().getDefaultDelimiter());
    }

    public Map<String, String> getSystemEnvMap() {
        IEnvironmentVariableManager buildEnvironmentManager = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IEnvironmentVariable[] variables = buildEnvironmentManager.getVariables(null, true);
        Map<String, String> envMap = IDFUtil.getSystemEnv();
        if (variables != null) {
            IEnvironmentVariable[] iEnvironmentVariableArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable iEnvironmentVariable = iEnvironmentVariableArray[n2];
                String key = iEnvironmentVariable.getName();
                if (!key.equals("IDF_TOOLS_PATH")) {
                    String value = iEnvironmentVariable.getValue();
                    envMap.put(key, value);
                }
                ++n2;
            }
        }
        return envMap;
    }

    public Map<String, String> getEnvMap() {
        IEnvironmentVariableManager buildEnvironmentManager = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IEnvironmentVariable[] vars = buildEnvironmentManager.getContributedEnvironment().getVariables(null);
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (vars != null) {
            IEnvironmentVariable[] iEnvironmentVariableArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable iEnvironmentVariable = iEnvironmentVariableArray[n2];
                String key = iEnvironmentVariable.getName();
                String value = iEnvironmentVariable.getValue();
                envMap.put(key, value);
                ++n2;
            }
        }
        return envMap;
    }
}

