/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.Messages;
import java.net.InetAddress;
import java.net.ServerSocket;

public class PortChecker {
    private static final int MAX_ATTEMPS = 20;

    private PortChecker() {
    }

    public static boolean isPortAvailable(int port) {
        block12: {
            Throwable throwable = null;
            Object var2_4 = null;
            ServerSocket serverSocket = new ServerSocket(port, 50, InetAddress.getByName("127.0.0.1"));
            try {
                serverSocket.setReuseAddress(true);
                if (serverSocket == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (serverSocket != null) {
                            serverSocket.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    Logger.log("Port: " + port + " is not available");
                    return false;
                }
            }
            serverSocket.close();
        }
        return true;
    }

    public static int getAvailablePort(int port) {
        int attemptsCount = 0;
        while (!PortChecker.isPortAvailable(port) && attemptsCount < 20) {
            Logger.log(String.format(Messages.PortChecker_PortNotAvailable, port, port + 1));
            ++port;
            ++attemptsCount;
        }
        if (attemptsCount >= 20) {
            Logger.log(Messages.PortChecker_AttemptLimitExceededMsg);
            return port;
        }
        Logger.log(String.format(Messages.PortChecker_PortIsAvailable, port));
        return port;
    }
}

