/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import org.eclipse.cdt.lsp.clangd.ClangdConfiguration;
import org.eclipse.cdt.lsp.clangd.ClangdMetadata;
import org.eclipse.cdt.lsp.config.Configuration;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.ui.PlatformUI;

public class LspService {
    private final Configuration configuration;
    private final List<LanguageServerWrapper> languageServerWrappers;

    public LspService() {
        this((Configuration)PlatformUI.getWorkbench().getService(ClangdConfiguration.class), LanguageServiceAccessor.getStartedWrappers(null, (boolean)true).stream().filter(w -> "org.eclipse.cdt.lsp.server".equals(w.serverDefinition.id)).toList());
    }

    public LspService(Configuration configuration, List<LanguageServerWrapper> languageServerWrappers) {
        this.configuration = configuration;
        this.languageServerWrappers = languageServerWrappers;
    }

    public void restartLspServers() {
        this.languageServerWrappers.forEach(w -> {
            CompletionStage completionStage = w.execute(ls -> ls.shutdown()).thenRun(() -> ((LanguageServerWrapper)w).restart());
        });
    }

    public void updateAdditionalOptions(String additionalOptions) {
        if (additionalOptions == null) {
            Logger.log("Skipped updating additional options: value is null");
            return;
        }
        String qualifier = this.configuration.qualifier();
        InstanceScope.INSTANCE.getNode(qualifier).put(ClangdMetadata.Predefined.additionalOptions.identifer(), additionalOptions);
    }

    public void updateClangdPath() {
        String clangdPath = IDFUtil.findCommandFromBuildEnvPath("clangd");
        if (clangdPath == null) {
            Logger.log("clangd executable not found in build environment path. Skipping clangd path update.");
            return;
        }
        String qualifier = this.configuration.qualifier();
        InstanceScope.INSTANCE.getNode(qualifier).put(ClangdMetadata.Predefined.clangdPath.identifer(), clangdPath);
    }

    public void updateQueryDriver() {
        String qualifier = this.configuration.qualifier();
        InstanceScope.INSTANCE.getNode(qualifier).put(ClangdMetadata.Predefined.queryDriver.identifer(), "**");
    }

    public void updateCompileCommandsDir(String buildDir) {
        String qualifier = this.configuration.qualifier();
        String identifier = ClangdMetadata.Predefined.additionalOptions.identifer();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(qualifier);
        String existingOptions = preferences.get(identifier, "");
        String compileCommandsDirString = "--compile-commands-dir=";
        String newCompuileCommandsDirString = compileCommandsDirString + buildDir;
        String updatedOptions = existingOptions.contains(compileCommandsDirString) ? existingOptions.replaceAll(compileCommandsDirString + ".+", Matcher.quoteReplacement(newCompuileCommandsDirString)) : newCompuileCommandsDirString;
        preferences.put(identifier, updatedOptions);
    }
}

