/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools.watcher;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.EimConstants;
import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.prefs.Preferences;

public class EimJsonStateChecker {
    private static final String LAST_MODIFIED_PREF_KEY = "lastEimJsonModified";
    private final Preferences preferences;

    public EimJsonStateChecker(Preferences preferences) {
        this.preferences = preferences;
    }

    public boolean wasModifiedSinceLastRun() {
        File jsonFile = new File(this.getEimJsonPath());
        if (!jsonFile.exists()) {
            return false;
        }
        long lastModified = jsonFile.lastModified();
        long lastSeen = this.preferences.getLong(LAST_MODIFIED_PREF_KEY, 0L);
        if (lastSeen == 0L) {
            Logger.log("eim_idf.json detected, but no last seen timestamp \u2014 assuming first run.");
            return false;
        }
        return lastModified > lastSeen;
    }

    public void updateLastSeenTimestamp() {
        File jsonFile = new File(this.getEimJsonPath());
        if (jsonFile.exists()) {
            this.preferences.putLong(LAST_MODIFIED_PREF_KEY, jsonFile.lastModified());
        }
    }

    private String getEimJsonPath() {
        return Platform.getOS().equals("win32") ? EimConstants.EIM_WIN_PATH : EimConstants.EIM_POSIX_PATH;
    }
}

