/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools.util;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.vo.IdfInstalled;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;

public class ToolsUtility {
    public static String getIdfVersion(IdfInstalled idfInstalled, String gitPath) {
        String activationScript = idfInstalled.getActivationScript();
        String espIdfVersion = null;
        try {
            List<String> args = ToolsUtility.getExportScriptCommand(activationScript);
            String[] command = args.toArray(new String[args.size()]);
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.directory(new File(activationScript).getParentFile());
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            Throwable throwable = null;
            Object var9_11 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("ESP_IDF_VERSION=")) continue;
                    espIdfVersion = line.split("=")[1];
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            process.waitFor();
        }
        catch (Exception e) {
            Logger.log(e);
        }
        return espIdfVersion;
    }

    public static List<String> getExportScriptCommand(String activationScriptPath) {
        ArrayList<String> command = new ArrayList<String>();
        if (Platform.getOS().equals("win32")) {
            command.add("powershell.exe");
            command.add("-ExecutionPolicy");
            command.add("Bypass");
            command.add("-File");
            command.add(activationScriptPath);
            command.add("-e");
        } else if (Platform.getOS().equals("linux")) {
            command.add("/bin/bash");
            command.add(activationScriptPath);
            command.add("-e");
        } else {
            command.add("/bin/zsh");
            command.add(activationScriptPath);
            command.add("-e");
        }
        return command;
    }

    public static boolean isIdfInstalledActive(IdfInstalled idfInstalled) {
        IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
        String espIdfIdEim = idfEnvironmentVariables.getEnvValue("ESP_IDF_EIM_ID");
        return idfInstalled.getId().equals(espIdfIdEim);
    }
}

