/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.configparser;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.configparser.vo.Board;
import com.espressif.idf.core.configparser.vo.EspConfig;
import com.espressif.idf.core.configparser.vo.Option;
import com.espressif.idf.core.configparser.vo.Target;
import com.espressif.idf.core.logging.Logger;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class EspConfigParser {
    private final String espConfigPath;
    private final Gson gson = new Gson();
    private final EspConfig config;

    public EspConfigParser() {
        this.espConfigPath = new IDFEnvironmentVariables().getEnvValue("OPENOCD_SCRIPTS") + "/esp-config.json";
        this.config = this.loadConfig();
    }

    public EspConfigParser(String espConfigPath) {
        this.espConfigPath = espConfigPath;
        this.config = this.loadConfig();
    }

    private EspConfig loadConfig() {
        File file = new File(this.espConfigPath);
        if (!file.exists()) {
            Logger.log("esp-config.json not found at: " + this.espConfigPath);
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileReader reader = new FileReader(file);){
                return (EspConfig)this.gson.fromJson((Reader)reader, EspConfig.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.log(e);
            return null;
        }
    }

    public Set<String> getTargets() {
        LinkedHashSet<String> targets = new LinkedHashSet<String>();
        if (this.config == null || this.config.targets() == null) {
            return targets;
        }
        for (Target target : this.config.targets()) {
            if (target.id() == null) continue;
            targets.add(target.id());
        }
        return targets;
    }

    public List<String> getEspFlashVoltages() {
        ArrayList<String> voltages = new ArrayList<String>();
        if (this.config == null || this.config.options() == null) {
            return voltages;
        }
        for (Option option : this.config.options()) {
            if (!"ESP_FLASH_VOLTAGE".equals(option.name()) || option.values() == null) continue;
            voltages.addAll(option.values());
            break;
        }
        return voltages;
    }

    public List<Board> getBoardsForTarget(String target) {
        ArrayList<Board> boardsForTarget = new ArrayList<Board>();
        if (this.config == null || this.config.boards() == null) {
            return boardsForTarget;
        }
        for (Board board : this.config.boards()) {
            if (!target.equals(board.target()) || board.name() == null || board.config_files() == null) continue;
            boardsForTarget.add(board);
        }
        return boardsForTarget;
    }

    public boolean hasBoardConfigJson() {
        return new File(this.espConfigPath).exists();
    }
}

