/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.core.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlUtil {
    public static String getRootTag(String xmlStr) {
        Matcher m = Pattern.compile("^[\r\n \t]*<.*?>[\r\n \t]*<(.*?)>", 40).matcher(xmlStr);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static String addTagData(String elementName, String data) {
        return XmlUtil.addTagData(elementName, data, false);
    }

    public static String addTagDataBoolean(String elementName, boolean data) {
        return XmlUtil.addTagData(elementName, data ? "true" : "false", false);
    }

    public static String addTagData(String elementName, String data, boolean newLine) {
        String str = "<" + elementName + ">" + data + "</" + elementName + ">";
        if (newLine) {
            return str + "\n";
        }
        return str;
    }

    public static String[] getNameValue(String xmlRoot, String xmlStr) {
        String[] strs = new String[]{"", ""};
        Matcher m = Pattern.compile("<" + xmlRoot + " name=\"(.*?)\" value=\"(.*?)\" />", 40).matcher(xmlStr);
        if (m.find()) {
            strs[0] = m.group(1);
            strs[1] = m.group(2);
        }
        return strs;
    }

    public static String getNameValueXml(String xmlRoot, String name, String value) {
        return String.format("<%s name=\"%s\" value=\"%s\"/>", xmlRoot, name, value);
    }

    public static String[] getTagDataArray(String xmlStr, String xmlRoot) {
        ArrayList<String> data = new ArrayList<String>();
        Matcher m = Pattern.compile("<" + xmlRoot + ">(.*?)</" + xmlRoot + ">", 40).matcher(xmlStr);
        while (m.find()) {
            data.add(XmlUtil.xmlToText(m.group(1)));
        }
        return data.toArray(new String[data.size()]);
    }

    public static String getTagData(String xmlStr, String xmlRoot) {
        String[] tags = XmlUtil.getTagDataArray(xmlStr, xmlRoot);
        if (tags.length > 0) {
            return tags[0];
        }
        return "";
    }

    public static int getTagIntData(String xmlStr, String xmlRoot) {
        String[] tags = XmlUtil.getTagDataArray(xmlStr, xmlRoot);
        if (tags.length > 0) {
            String intStr = tags[0];
            return Integer.valueOf(intStr);
        }
        return 0;
    }

    public static Boolean getTagBooleanData(String xmlStr, String xmlRoot) {
        String[] tags = XmlUtil.getTagDataArray(xmlStr, xmlRoot);
        if (tags.length > 0) {
            String intStr = tags[0];
            return intStr.equals("true");
        }
        return false;
    }

    public static String textToXml(String text) {
        if (text == null || text.equals("")) {
            return "";
        }
        String str = text;
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll("'", "&apos;");
        str = str.replaceAll("\"", "&quot;");
        return str;
    }

    public static String xmlToText(String xml) {
        if (xml == null || xml.equals("")) {
            return "";
        }
        String str = xml;
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&apos;", "'");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&amp;", "&");
        return str;
    }
}

