/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.serial.server;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.terminal.connector.serial.connector.SerialConnector;
import com.espressif.idf.terminal.connector.serial.launcher.CoreDumpPostmortemDebuggerLauncher;
import com.espressif.idf.terminal.connector.serial.launcher.GDBStubDebuggerLauncher;
import com.espressif.idf.terminal.connector.serial.launcher.ISerialWebSocketEventLauncher;
import com.espressif.idf.terminal.connector.serial.nls.Messages;
import com.espressif.idf.terminal.connector.serial.server.SocketServerHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SocketServerMessageHandler
extends Thread {
    private SerialConnector serialConnector;
    private IProject project;

    public SocketServerMessageHandler(SerialConnector serialConnector, IProject project) {
        this.project = project;
        this.serialConnector = serialConnector;
    }

    @Override
    public void run() {
        boolean running = true;
        while (running) {
            if (SocketServerHandler.getInstance().getMessagesQueue().isEmpty()) {
                try {
                    SocketServerMessageHandler.sleep(500L);
                }
                catch (InterruptedException e) {
                    Logger.logError((String)e.getMessage());
                }
                continue;
            }
            try {
                this.parseMessage(SocketServerHandler.getInstance().getMessagesQueue().poll());
                running = false;
            }
            catch (Exception e) {
                Logger.log((Exception)e);
            }
        }
    }

    private void parseMessage(String message) throws Exception {
        JSONObject messageJsonObject = (JSONObject)new JSONParser().parse(message);
        String event = messageJsonObject.get((Object)"event").toString();
        ISerialWebSocketEventLauncher iSerialWebSocketEventLauncher = null;
        Logger.log((String)"Event Received on Socket Server: ".concat(event));
        MessageBoxDisplay messageBoxDisplay = new MessageBoxDisplay(event);
        Display.getDefault().syncExec((Runnable)messageBoxDisplay);
        int messageBoxResponse = messageBoxDisplay.getResponse();
        if ("gdb_stub".equals(event)) {
            iSerialWebSocketEventLauncher = new GDBStubDebuggerLauncher(message, this.project);
        } else if ("coredump".equals(event)) {
            iSerialWebSocketEventLauncher = new CoreDumpPostmortemDebuggerLauncher(message, this.project);
        }
        if (iSerialWebSocketEventLauncher != null && messageBoxResponse == 64) {
            final IFile launchFile = iSerialWebSocketEventLauncher.launchDebugSession();
            this.serialConnector.disconnect();
            final LaunchManager launchManager = new LaunchManager();
            Thread launchDebugThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        launchManager.getLaunchConfiguration(launchFile).launch("debug", (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        Logger.log((Exception)e);
                    }
                }
            });
            SocketServerHandler.getInstance().broadcastMessageToClients("{\"event\" : \"debug_finished\"}");
            if (launchFile != null && launchFile.exists()) {
                launchDebugThread.start();
            }
        } else {
            Logger.log((String)"Event capture not yet implemented");
        }
    }

    private class MessageBoxDisplay
    implements Runnable {
        private String event;
        private int response;

        private MessageBoxDisplay(String event) {
            this.event = event;
        }

        @Override
        public void run() {
            MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 194);
            messageBox.setText(Messages.MessageBox_SocketServerEventTitle);
            messageBox.setMessage(String.format(Messages.MessageBox_SocketServerEventMessage, this.event));
            this.response = messageBox.open();
        }

        private int getResponse() {
            return this.response;
        }
    }
}

