/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.serial.connector;

import com.espressif.idf.core.util.StringUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.terminal.connector.ISettingsStore;

public class SerialSettings {
    public static final String PORT_NAME_ATTR = "cdtserial.portName";
    public static final String MONITOR_FILTER = "idf.monitor.filter";
    public static final String SELECTED_PROJECT_ATTR = "idf.monitor.project";
    public static final String ENCRYPTION_ATTR = "idf.monitor.encryption";
    private String portName;
    private String filterText;
    private String selectedProject;
    private boolean encryptionOption;

    public void load(ISettingsStore store) {
        this.portName = store.get(PORT_NAME_ATTR, "");
        this.filterText = store.get(MONITOR_FILTER, "");
        this.selectedProject = store.get(SELECTED_PROJECT_ATTR, "");
        this.encryptionOption = Boolean.parseBoolean(store.get(ENCRYPTION_ATTR, "false"));
    }

    public void save(ISettingsStore store) {
        store.put(PORT_NAME_ATTR, this.portName);
        store.put(MONITOR_FILTER, this.filterText);
        store.put(SELECTED_PROJECT_ATTR, this.selectedProject);
        store.put(ENCRYPTION_ATTR, Boolean.toString(this.encryptionOption));
    }

    public String getPortName() {
        return this.portName;
    }

    public String getFilterText() {
        return this.filterText;
    }

    public String getProjectName() {
        return this.selectedProject;
    }

    public boolean getEncryptionOption() {
        return this.encryptionOption;
    }

    public IProject getProject() {
        return !StringUtil.isEmpty((String)this.selectedProject) ? ResourcesPlugin.getWorkspace().getRoot().getProject(this.selectedProject) : null;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public void setFilterText(String filterText) {
        this.filterText = filterText;
    }

    public String getSummary() {
        return this.portName;
    }

    public void setProject(String projectName) {
        this.selectedProject = projectName;
    }

    public void setEncryptionOption(boolean encryptionOption) {
        this.encryptionOption = encryptionOption;
    }
}

