/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.serial.connector;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.serial.monitor.handlers.SerialMonitorHandler;
import com.espressif.idf.terminal.connector.serial.activator.Activator;
import com.espressif.idf.terminal.connector.serial.connector.SerialConnector;
import com.espressif.idf.terminal.connector.serial.server.SocketServerHandler;
import com.espressif.idf.terminal.connector.serial.server.SocketServerMessageHandler;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.terminal.connector.TerminalState;

public class SerialPortHandler {
    private final String portName;
    private boolean isOpen;
    private boolean isPaused;
    private Object pauseMutex = new Object();
    private static final Map<String, LinkedList<WeakReference<SerialPortHandler>>> openPorts = new HashMap<String, LinkedList<WeakReference<SerialPortHandler>>>();
    private Process process;
    private Thread thread;
    private SerialConnector serialConnector;
    private SocketServerMessageHandler serverMessageHandler;
    private SocketServerHandler socketServerHandler;

    private static String adjustPortName(String portName) {
        return portName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SerialPortHandler get(String portName) {
        Map<String, LinkedList<WeakReference<SerialPortHandler>>> map = openPorts;
        synchronized (map) {
            LinkedList<WeakReference<SerialPortHandler>> list;
            block6: {
                list = openPorts.get(SerialPortHandler.adjustPortName(portName));
                if (list != null) break block6;
                return null;
            }
            Iterator i = list.iterator();
            while (i.hasNext()) {
                WeakReference ref = (WeakReference)i.next();
                SerialPortHandler port = (SerialPortHandler)ref.get();
                if (port == null) {
                    i.remove();
                    continue;
                }
                return port;
            }
            return null;
        }
    }

    public SerialPortHandler(String portName, SerialConnector serialConnector, IProject project) {
        this.portName = SerialPortHandler.adjustPortName(portName);
        this.serialConnector = serialConnector;
        this.serverMessageHandler = new SocketServerMessageHandler(serialConnector, project);
    }

    public String getPortName() {
        return this.portName;
    }

    private int startSocketServerThread() throws Exception {
        this.socketServerHandler = SocketServerHandler.getInstance();
        this.socketServerHandler.startServer();
        return SocketServerHandler.getServerPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() {
        int serverPort;
        this.serialConnector.control.setState(TerminalState.CONNECTING);
        try {
            serverPort = this.startSocketServerThread();
        }
        catch (Exception e1) {
            Logger.log((Exception)e1);
            return;
        }
        SerialMonitorHandler serialMonitorHandler = new SerialMonitorHandler(this.serialConnector.project, this.portName, this.serialConnector.filterOptions, this.serialConnector.encryptionOption, serverPort);
        this.serialConnector.process = this.process = serialMonitorHandler.invokeIDFMonitor();
        this.thread = new Thread(){

            @Override
            public void run() {
                InputStream targetIn = SerialPortHandler.this.process.getInputStream();
                byte[] buff = new byte[256];
                try {
                    int n;
                    while ((n = targetIn.read(buff, 0, buff.length)) >= 0) {
                        if (n == 0) continue;
                        SerialPortHandler.this.serialConnector.control.getRemoteToTerminalOutputStream().write(buff, 0, n);
                    }
                    SerialPortHandler.this.serialConnector.disconnect();
                }
                catch (Exception e) {
                    Activator.log(e);
                    SerialPortHandler.this.serialConnector.disconnect();
                    SerialPortHandler.this.stopWebSocketServer();
                    SerialPortHandler.this.process.destroy();
                    SerialPortHandler.this.serialConnector.control.setState(TerminalState.CLOSED);
                }
            }
        };
        this.thread.start();
        if (!this.serverMessageHandler.isAlive()) {
            this.serverMessageHandler.start();
        }
        this.isOpen = true;
        this.serialConnector.control.setState(TerminalState.CONNECTED);
        Map<String, LinkedList<WeakReference<SerialPortHandler>>> map = openPorts;
        synchronized (map) {
            LinkedList<WeakReference<SerialPortHandler>> list = openPorts.get(this.portName);
            if (list == null) {
                list = new LinkedList();
                openPorts.put(this.portName, list);
            }
            list.addFirst(new WeakReference<SerialPortHandler>(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.isOpen) {
            this.isOpen = false;
            if (this.process != null) {
                this.stopWebSocketServer();
                this.process.destroy();
            }
            if (this.thread != null) {
                this.thread.interrupt();
            }
            Map<String, LinkedList<WeakReference<SerialPortHandler>>> map = openPorts;
            synchronized (map) {
                LinkedList<WeakReference<SerialPortHandler>> list = openPorts.get(this.portName);
                if (list != null) {
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        WeakReference ref = (WeakReference)i.next();
                        SerialPortHandler port = (SerialPortHandler)ref.get();
                        if (port != null && !port.equals(this)) continue;
                        i.remove();
                    }
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws IOException {
        if (!this.isOpen) {
            return;
        }
        Object object = this.pauseMutex;
        synchronized (object) {
            this.isPaused = true;
            this.close();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws IOException {
        Object object = this.pauseMutex;
        synchronized (object) {
            if (!this.isPaused) {
                return;
            }
            this.isPaused = false;
            this.open();
            this.isOpen = true;
            this.pauseMutex.notifyAll();
        }
    }

    private void stopWebSocketServer() {
        try {
            SocketServerHandler.getInstance().stopServer();
        }
        catch (Exception e) {
            Logger.log((Exception)e);
        }
    }
}

