/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools.watcher;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.EimConstants;
import com.espressif.idf.core.tools.watcher.EimJsonChangeListener;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Platform;

public class EimJsonWatchService
extends Thread {
    private final WatchService watchService;
    private final Path watchDirectoryPath;
    private final List<EimJsonChangeListener> eimJsonChangeListeners = new CopyOnWriteArrayList<EimJsonChangeListener>();
    private volatile boolean running = true;
    private volatile boolean paused = false;
    private volatile Instant lastModifiedTime;

    private EimJsonWatchService() throws IOException {
        String directoryPathString = Platform.getOS().equals("win32") ? EimConstants.EIM_WIN_DIR : EimConstants.EIM_POSIX_DIR;
        this.watchDirectoryPath = Paths.get(directoryPathString, new String[0]);
        if (!Files.exists(this.watchDirectoryPath, new LinkOption[0])) {
            Files.createDirectories(this.watchDirectoryPath, new FileAttribute[0]);
        }
        this.watchService = FileSystems.getDefault().newWatchService();
        this.watchDirectoryPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        Logger.log("Watcher added to the directory: " + directoryPathString);
        this.setName("EimJsonWatchService");
        this.setDaemon(true);
        this.start();
    }

    public static EimJsonWatchService getInstance() {
        return Holder.INSTANCE;
    }

    public void addEimJsonChangeListener(EimJsonChangeListener listener) {
        if (listener != null) {
            this.eimJsonChangeListeners.add(listener);
        }
    }

    public void removeAllListeners() {
        this.eimJsonChangeListeners.clear();
    }

    public static void withPausedListeners(Runnable task) {
        EimJsonWatchService watchService = EimJsonWatchService.getInstance();
        boolean wasPaused = watchService.paused;
        watchService.pauseListeners();
        try {
            try {
                task.run();
            }
            catch (Exception e) {
                Logger.log(e);
                if (!wasPaused) {
                    watchService.unpauseListeners();
                }
            }
        }
        finally {
            if (!wasPaused) {
                watchService.unpauseListeners();
            }
        }
    }

    public void pauseListeners() {
        Logger.log("Listeners are paused");
        this.paused = true;
    }

    public void unpauseListeners() {
        Logger.log("Listeners are resumed");
        this.paused = false;
    }

    @Override
    public void run() {
        while (this.running) {
            WatchKey key;
            try {
                key = this.watchService.take();
            }
            catch (InterruptedException e) {
                Logger.log("Watch Service Interrupted");
                Thread.currentThread().interrupt();
                break;
            }
            catch (ClosedWatchServiceException cwse) {
                break;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                Path path;
                Object context;
                if (event.kind() == StandardWatchEventKinds.OVERFLOW || !((context = event.context()) instanceof Path) || !(path = (Path)context).toString().equals("eim_idf.json")) continue;
                Path fullPath = this.watchDirectoryPath.resolve(path);
                try {
                    Instant currentModified = Files.getLastModifiedTime(fullPath, new LinkOption[0]).toInstant().truncatedTo(ChronoUnit.SECONDS);
                    if (this.lastModifiedTime != null && currentModified.compareTo(this.lastModifiedTime) <= 0) continue;
                    this.lastModifiedTime = currentModified;
                    for (EimJsonChangeListener listener : this.eimJsonChangeListeners) {
                        listener.onJsonFileChanged(fullPath, this.paused);
                    }
                }
                catch (IOException e) {
                    Logger.log(e);
                }
            }
            boolean valid = key.reset();
            if (!valid) break;
        }
        try {
            this.watchService.close();
            Logger.log("File Watch Service close");
        }
        catch (IOException e) {
            Logger.log("Failed to close WatchService");
            Logger.log(e);
        }
    }

    @Override
    public void interrupt() {
        this.running = false;
        super.interrupt();
    }

    public void shutdown() {
        this.running = false;
        this.interrupt();
    }

    private static class Holder {
        private static EimJsonWatchService INSTANCE;

        static {
            try {
                INSTANCE = new EimJsonWatchService();
            }
            catch (IOException e) {
                Logger.log("Failed to initialize EimJsonWatchService");
                Logger.log(e);
            }
        }

        private Holder() {
        }
    }
}

