/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools.launch.strategies;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.launch.LaunchResult;
import com.espressif.idf.core.tools.launch.ProcessUtils;
import com.espressif.idf.core.tools.launch.ProcessWaiter;
import com.espressif.idf.core.tools.launch.strategies.AbstractLoggingLauncherStrategy;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsoleStream;

public final class LinuxEimLauncherStrategy
extends AbstractLoggingLauncherStrategy {
    public LinuxEimLauncherStrategy(Display display, MessageConsoleStream standardConsoleStream, MessageConsoleStream errorConsoleStream) {
        super(display, standardConsoleStream, errorConsoleStream);
    }

    @Override
    public LaunchResult launch(String eimPath) throws IOException {
        if (!Files.exists(Paths.get(eimPath, new String[0]), new LinkOption[0])) {
            throw new IOException("EIM path not found: " + eimPath);
        }
        String quotedPath = ProcessUtils.bashSingleQuote(eimPath);
        String bashCmd = "nohup " + quotedPath + " > /dev/null 2>&1 & echo $!";
        List<CallSite> command = List.of("bash", "-lc", bashCmd);
        Process launcher = new ProcessBuilder(command).redirectErrorStream(true).start();
        String out = ProcessUtils.readAll(launcher.getInputStream());
        Long pid = ProcessUtils.parseFirstLongLine(out);
        if (pid == null) {
            Logger.log("Linux launcher output was:\n" + out);
            throw new IOException("No PID found in launcher output. Output was:\n" + out);
        }
        return LaunchResult.ofPid(pid, eimPath, out);
    }

    @Override
    public IStatus waitForExit(LaunchResult launchResult, IProgressMonitor monitor) {
        return ProcessWaiter.waitForExitByPid(launchResult.pid(), monitor);
    }
}

