/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools.launch;

import com.espressif.idf.core.tools.launch.strategies.EimLauncherStrategy;
import com.espressif.idf.core.tools.launch.strategies.LinuxEimLauncherStrategy;
import com.espressif.idf.core.tools.launch.strategies.MacOsEimLauncherStrategy;
import com.espressif.idf.core.tools.launch.strategies.WindowsEimLauncherStrategy;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsoleStream;

public final class EimLauncherFactory {
    private EimLauncherFactory() {
    }

    public static EimLauncherStrategy create(Display display, MessageConsoleStream standardConsoleStream, MessageConsoleStream errorConsoleStream) {
        String os = Platform.getOS();
        if ("macosx".equals(os)) {
            return new MacOsEimLauncherStrategy(display, standardConsoleStream, errorConsoleStream);
        }
        if ("win32".equals(os)) {
            return new WindowsEimLauncherStrategy(display, standardConsoleStream, errorConsoleStream);
        }
        if ("linux".equals(os)) {
            return new LinuxEimLauncherStrategy(display, standardConsoleStream, errorConsoleStream);
        }
        throw new UnsupportedOperationException("Unsupported OS: " + os);
    }
}

