/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools.launch;

import com.espressif.idf.core.tools.launch.EimLauncherFactory;
import com.espressif.idf.core.tools.launch.LaunchResult;
import com.espressif.idf.core.tools.launch.strategies.EimLauncherStrategy;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsoleStream;

public final class EimLaunchService {
    private final EimLauncherStrategy strategy;

    public EimLaunchService(Display display, MessageConsoleStream standardConsoleStream, MessageConsoleStream errorConsoleStream) {
        this.strategy = EimLauncherFactory.create(display, standardConsoleStream, errorConsoleStream);
    }

    public LaunchResult launch(String eimPath) throws IOException {
        if (eimPath == null || eimPath.isBlank()) {
            throw new IOException("EIM path is null/blank");
        }
        if (!Files.exists(Paths.get(eimPath, new String[0]), new LinkOption[0])) {
            throw new IOException("EIM path not found: " + eimPath);
        }
        return this.strategy.launch(eimPath);
    }

    public IStatus waitForExit(LaunchResult launchResult, IProgressMonitor monitor) {
        return this.strategy.waitForExit(launchResult, monitor);
    }
}

