/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.EimConstants;
import com.espressif.idf.core.tools.EimIdfConfiguratinParser;
import com.espressif.idf.core.tools.exceptions.EimVersionMismatchException;
import com.espressif.idf.core.tools.vo.EimJson;
import com.espressif.idf.core.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.service.prefs.Preferences;

public class ToolInitializer {
    private final Preferences preferences;
    private final EimIdfConfiguratinParser parser;
    private IDFEnvironmentVariables idfEnvironmentVariables;

    public ToolInitializer(Preferences preferences) {
        this.preferences = preferences;
        this.parser = new EimIdfConfiguratinParser();
        this.idfEnvironmentVariables = new IDFEnvironmentVariables();
    }

    public boolean isEimInstalled() {
        java.nio.file.Path defaultEimPath;
        boolean exists;
        String eimExePathEnv = this.idfEnvironmentVariables.getEnvValue("EIM_PATH");
        boolean bl = exists = !StringUtil.isEmpty(eimExePathEnv) && Files.exists(Paths.get(eimExePathEnv, new String[0]), new LinkOption[0]);
        if (!exists && (defaultEimPath = this.getDefaultEimPath()) != null) {
            exists = Files.exists(defaultEimPath, new LinkOption[0]);
        }
        return exists;
    }

    public boolean isEimIdfJsonPresent() {
        String path = Platform.getOS().equals("win32") ? EimConstants.EIM_WIN_PATH : EimConstants.EIM_POSIX_PATH;
        return new File(path).exists();
    }

    public EimJson loadEimJson() throws EimVersionMismatchException {
        try {
            return this.parser.getEimJson(true);
        }
        catch (IOException e) {
            Logger.log(e);
            return null;
        }
    }

    public boolean isOldEspIdfConfigPresent() {
        return this.getOldConfigFile().exists();
    }

    public IStatus exportOldConfig(java.nio.file.Path eimPath) throws IOException {
        File oldConfig = this.getOldConfigFile();
        if (oldConfig.exists()) {
            ArrayList<String> commands = new ArrayList<String>();
            String eimPathStr = "";
            if (eimPath == null || !Files.exists(eimPath, new LinkOption[0])) {
                return new Status(4, IDFCorePlugin.getId(), -1, "Cannot Convert EIM is not installed", null);
            }
            eimPathStr = eimPath.toString();
            commands.add(eimPathStr);
            commands.add("import");
            commands.add(oldConfig.getAbsolutePath());
            Logger.log("Running: " + ((Object)commands).toString());
            ProcessBuilderFactory processBuilderFactory = new ProcessBuilderFactory();
            IStatus status = processBuilderFactory.runInBackground(commands, (IPath)Path.ROOT, System.getenv());
            Logger.log(status.getMessage());
            return status;
        }
        return new Status(4, IDFCorePlugin.getId(), -1, "Error in conversion", null);
    }

    public boolean isOldConfigExported() {
        return this.preferences.getBoolean("OLD_CONFIG_EXPORTED_FLAG", false);
    }

    private File getOldConfigFile() {
        IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        return new File(path.toOSString(), "tool_set_config.json");
    }

    public boolean isEspIdfSet() {
        return this.preferences.getBoolean("INSTALL_TOOLS_FLAG", false);
    }

    public java.nio.file.Path getDefaultEimPath() {
        String userHome = System.getProperty("user.home");
        String os = Platform.getOS();
        java.nio.file.Path defaultEimPath = os.equals("win32") ? Paths.get(userHome, ".espressif", "eim_gui", "eim.exe") : (os.equals("macosx") ? Paths.get("/Applications", "eim.app", "Contents", "MacOS", "eim") : Paths.get(userHome, ".espressif", "eim_gui", "eim"));
        return defaultEimPath;
    }

    public void findAndSetEimPath() {
        java.nio.file.Path defaultEimPath = this.getDefaultEimPath();
        if (defaultEimPath != null) {
            this.setEimPathInEnvVar(defaultEimPath.toString());
        }
    }

    private void setEimPathInEnvVar(String eimPath) {
        this.idfEnvironmentVariables.addEnvVariable("EIM_PATH", eimPath);
    }
}

