/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.DownloadListener;
import com.espressif.idf.core.tools.EimConstants;
import com.espressif.idf.core.tools.launch.EimLaunchService;
import com.espressif.idf.core.tools.launch.LaunchResult;
import com.espressif.idf.core.tools.watcher.EimJsonWatchService;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsoleStream;

public class EimLoader {
    private static final String URL_JSON = "https://dl.espressif.com/dl/eim/eim_unified_release.json";
    private static final Path DOWNLOAD_DIR = Paths.get(System.getProperty("java.io.tmpdir"), "eim_gui");
    private final String os = Platform.getOS();
    private final String arch = Platform.getOSArch();
    private final DownloadListener listener;
    private final MessageConsoleStream standardConsoleStream;
    private final MessageConsoleStream errorConsoleStream;
    private final Display display;
    private final EimLaunchService launchService;
    private volatile LaunchResult lastLaunchResult;

    public EimLoader(DownloadListener listener, MessageConsoleStream standardConsoleStream, MessageConsoleStream errorConsoleStream, Display display) {
        this.listener = listener;
        this.standardConsoleStream = standardConsoleStream;
        this.errorConsoleStream = errorConsoleStream;
        this.display = display;
        this.launchService = new EimLaunchService(display, standardConsoleStream, errorConsoleStream);
    }

    private void logMessage(String message) {
        this.display.asyncExec(() -> {
            try {
                this.standardConsoleStream.write(message);
            }
            catch (IOException e) {
                Logger.log(e);
                this.logError(e.getMessage());
            }
        });
        Logger.log(message);
    }

    private void logError(String message) {
        this.display.asyncExec(() -> {
            try {
                this.errorConsoleStream.write(message);
            }
            catch (IOException e) {
                Logger.log(e);
            }
        });
        Logger.log(message);
    }

    public LaunchResult launchEimWithResult(String eimPath) throws IOException {
        LaunchResult result;
        this.lastLaunchResult = result = this.launchService.launch(eimPath);
        this.logMessage("Launched EIM application: " + eimPath + " (pid=" + result.pid().orElse(-1L) + ")\n");
        return result;
    }

    public void waitForEimClosure(final LaunchResult launchResult, final Runnable callback) {
        Job waitJob = new Job("Wait for EIM Closure"){

            protected IStatus run(IProgressMonitor monitor) {
                return EimLoader.this.launchService.waitForExit(launchResult, monitor);
            }
        };
        waitJob.setSystem(true);
        waitJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                EimJsonWatchService.getInstance().pauseListeners();
            }

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(() -> {
                    try {
                        EimLoader.this.standardConsoleStream.write("EIM has been closed.\n");
                    }
                    catch (IOException e) {
                        Logger.log(e);
                    }
                });
                if (callback != null) {
                    callback.run();
                }
                EimJsonWatchService.getInstance().unpauseListeners();
            }
        });
        waitJob.schedule();
    }

    public String installAndLaunchDmg(Path dmgPath) throws IOException, InterruptedException {
        this.logMessage("Mounting DMG\u2026\n");
        Process mountProcess = new ProcessBuilder("hdiutil", "attach", dmgPath.toString()).redirectErrorStream(true).start();
        int mountExit = mountProcess.waitFor();
        if (mountExit != 0) {
            throw new IOException("hdiutil attach failed (exit " + mountExit + "): " + this.readProcessOutput(mountProcess));
        }
        String volumePath = this.parseVolumePath(mountProcess.getInputStream());
        if (volumePath == null) {
            throw new IOException("Failed to mount DMG: volume path not found.");
        }
        File[] apps = new File(volumePath).listFiles((dir, name) -> name.endsWith(".app"));
        if (apps == null || apps.length == 0) {
            throw new FileNotFoundException("No .app found inside DMG.");
        }
        File appBundle = apps[0];
        Path targetAppPath = Paths.get("/Applications", appBundle.getName());
        this.logMessage("Copying app to /Applications\u2026\n");
        Process copyProcess = new ProcessBuilder("cp", "-R", appBundle.getAbsolutePath(), targetAppPath.toString()).redirectErrorStream(true).start();
        int copyExit = copyProcess.waitFor();
        if (copyExit != 0) {
            throw new IOException("Copy failed (exit " + copyExit + "): " + this.readProcessOutput(copyProcess));
        }
        this.logMessage("Unmounting DMG\u2026\n");
        Process detachProcess = new ProcessBuilder("hdiutil", "detach", volumePath).redirectErrorStream(true).start();
        int detachExit = detachProcess.waitFor();
        if (detachExit != 0) {
            throw new IOException("hdiutil detach failed (exit " + detachExit + "): " + this.readProcessOutput(detachProcess));
        }
        String eimPath = targetAppPath.resolve("Contents/MacOS/eim").toString();
        new IDFEnvironmentVariables().addEnvVariable("EIM_PATH", eimPath);
        return eimPath;
    }

    public void downloadEim(IProgressMonitor monitor) {
        block9: {
            try {
                JsonObject root = this.fetchJson();
                JsonArray assets = root.getAsJsonArray("assets");
                Optional<JsonObject> match = this.findMatchingAsset(assets);
                if (match.isEmpty()) {
                    this.listener.onError("No suitable EIM GUI asset found.", null);
                    monitor.done();
                    return;
                }
                try {
                    JsonObject asset = match.get();
                    String name = asset.get("name").getAsString();
                    String downloadUrl = asset.get("browser_download_url").getAsString();
                    Files.createDirectories(DOWNLOAD_DIR, new FileAttribute[0]);
                    this.cleanupDownloadDirectory();
                    Path downloadPath = DOWNLOAD_DIR.resolve(name);
                    this.downloadFile(downloadUrl, downloadPath, this.listener, monitor);
                    Path eimPath = Paths.get(EimConstants.USER_EIM_DIR, new String[0]);
                    Files.createDirectories(eimPath, new FileAttribute[0]);
                    if (name.endsWith(".zip")) {
                        Path extracted = this.unzip(downloadPath, eimPath);
                        this.listener.onCompleted(extracted.toAbsolutePath().toString());
                        break block9;
                    }
                    if (name.endsWith(".exe")) {
                        Path exePath = Paths.get(eimPath.toString(), name);
                        Files.copy(downloadPath, exePath, StandardCopyOption.REPLACE_EXISTING);
                        this.listener.onCompleted(exePath.toString());
                        break block9;
                    }
                    this.listener.onCompleted(downloadPath.toAbsolutePath().toString());
                }
                catch (IOException | URISyntaxException e) {
                    this.listener.onError("Download failed", e);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private JsonObject fetchJson() throws IOException, URISyntaxException {
        URL url = new URI(URL_JSON).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("accept", "application/json");
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
            return JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Optional<JsonObject> findMatchingAsset(JsonArray assets) {
        String osToken = switch (this.os) {
            case "win32" -> "windows";
            case "macosx" -> "macos";
            case "linux" -> "linux";
            default -> "";
        };
        String archToken = switch (this.arch) {
            case "x86_64" -> "x64";
            case "aarch64", "arm64" -> "aarch64";
            default -> "";
        };
        int i = 0;
        while (i < assets.size()) {
            JsonObject asset = assets.get(i).getAsJsonObject();
            String name = asset.get("name").getAsString().toLowerCase();
            if (name.contains("eim-gui") && name.contains(osToken) && name.contains(archToken) && (name.endsWith(".exe") || name.endsWith(".dmg") || name.endsWith(".zip"))) {
                return Optional.of(asset);
            }
            ++i;
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void downloadFile(String fileURL, Path targetPath, DownloadListener listener, IProgressMonitor monitor) throws IOException, URISyntaxException {
        URL url = new URI(fileURL).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        int contentLength = connection.getContentLength();
        monitor.beginTask("Downloading " + String.valueOf(targetPath.getFileName()), contentLength);
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            InputStream in = connection.getInputStream();
            try {
                try (OutputStream out = Files.newOutputStream(targetPath, new OpenOption[0]);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    long totalRead = 0L;
                    int lastPercent = 0;
                    while ((bytesRead = in.read(buffer)) != -1) {
                        int percent;
                        out.write(buffer, 0, bytesRead);
                        if (contentLength <= 0 || (percent = (int)((totalRead += (long)bytesRead) * 100L / (long)contentLength)) == lastPercent) continue;
                        listener.onProgress(percent);
                        lastPercent = percent;
                        monitor.worked(bytesRead);
                    }
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void cleanupDownloadDirectory() {
        try {
            Files.list(DOWNLOAD_DIR).filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    Logger.log("Failed to delete old download: " + String.valueOf(path));
                }
            });
        }
        catch (IOException e) {
            Logger.log("Failed to clean up download directory: " + e.getMessage());
        }
    }

    private Path unzip(Path zipPath, Path destDir) throws IOException {
        Files.createDirectories(destDir, new FileAttribute[0]);
        Path firstExecutable = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipPath.toFile()));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                Path newPath = destDir.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                if (firstExecutable != null || !Files.isRegularFile(newPath, new LinkOption[0])) continue;
                newPath.toFile().setExecutable(true);
                firstExecutable = newPath;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return firstExecutable != null ? firstExecutable : destDir;
    }

    private String readProcessOutput(Process p) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append(System.lineSeparator());
            }
            return sb.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String parseVolumePath(InputStream mountOut) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(mountOut));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("/Volumes/")) continue;
                String[] stringArray = line.split("\t");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    if (part.startsWith("/Volumes/")) {
                        return part.trim();
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }
}

