/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core;

import com.espressif.idf.core.IDFVersion;
import com.espressif.idf.core.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Version;

public class IDFVersionsReader {
    private static final String VERSIONS_URL = "https://dl.espressif.com/dl/esp-idf/idf_versions.txt";
    private static final String GITHUB_VERSION_URL = "https://github.com/espressif/esp-idf/releases/download/IDFZIPFileVersion/esp-idf-IDFZIPFileVersion.zip";
    private static final String ESPRESSIF_VERSION_URL = "https://dl.espressif.com/dl/esp-idf/releases/esp-idf-IDFZIPFileVersion.zip";
    private static final String MASTER_URL = "https://github.com/espressif/esp-idf.git";
    private static final String MIN_VERSION_SUPPORT = "4.0.0";

    public List<String> getVersions() {
        ArrayList<String> versionList = new ArrayList<String>();
        try {
            String inputLine;
            URL url = new URL(VERSIONS_URL);
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                versionList.add(inputLine);
            }
            in.close();
        }
        catch (IOException e) {
            Logger.log("Failed to load versions from https://dl.espressif.com/dl/esp-idf/idf_versions.txt");
            Logger.log(e);
        }
        return versionList;
    }

    public List<String> applyPluginFilter(List<String> versions) {
        ArrayList<String> filterList = new ArrayList<String>();
        for (String version : versions) {
            if (version.startsWith("master")) {
                filterList.add(version);
                continue;
            }
            if (version.startsWith("v")) {
                if (new Version(MIN_VERSION_SUPPORT).compareTo(new Version(version.replace("v", "").replaceAll("-.*", ".0"))) > 0) continue;
                filterList.add(version);
                continue;
            }
            if (!version.startsWith("release/") || new Version(MIN_VERSION_SUPPORT).compareTo(new Version(version.replace("release/v", ""))) > 0) continue;
            filterList.add(version);
        }
        return filterList;
    }

    public Map<String, IDFVersion> getVersionsMap() {
        LinkedHashMap<String, IDFVersion> versionsMap = new LinkedHashMap<String, IDFVersion>();
        String versionRegEx = "IDFZIPFileVersion";
        List<String> versions = this.applyPluginFilter(this.getVersions());
        for (String version : versions) {
            String espressifVersionUrl;
            String gitHubVersionUrl;
            Logger.log("Version: " + version);
            if (version.startsWith("master") || version.startsWith("release/")) {
                gitHubVersionUrl = MASTER_URL;
                espressifVersionUrl = MASTER_URL;
                versionsMap.put(version, new IDFVersion(version, gitHubVersionUrl, espressifVersionUrl));
                continue;
            }
            if (!version.startsWith("v")) continue;
            gitHubVersionUrl = GITHUB_VERSION_URL.replace(versionRegEx, version);
            espressifVersionUrl = ESPRESSIF_VERSION_URL.replace(versionRegEx, version);
            versionsMap.put(version, new IDFVersion(version, gitHubVersionUrl, espressifVersionUrl));
        }
        return versionsMap;
    }

    public static void main(String[] args) {
        IDFVersionsReader reader = new IDFVersionsReader();
        Map<String, IDFVersion> versionsMap = reader.getVersionsMap();
        for (Map.Entry<String, IDFVersion> entry : versionsMap.entrySet()) {
            IDFVersion idfVersion = entry.getValue();
            System.out.println("Version:" + entry.getKey());
            System.out.println("URL:" + idfVersion.getUrl());
            System.out.println("Mirror URL:" + idfVersion.getMirrorUrl());
            System.out.println("");
        }
    }
}

