/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui;

import com.cthing.cmakeed.core.utils.ClassUtils;
import com.cthing.cmakeed.ui.editor.CMakePartitionScanner;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CMakeEditorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.cthing.cmakeed.ui";
    public static final String CMAKE_PARTITIONING = "__cmake_partitioning";
    private static CMakeEditorPlugin plugin;
    private CMakePartitionScanner fPartitionScanner;

    public CMakeEditorPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static CMakeEditorPlugin getDefault() {
        return plugin;
    }

    public CMakePartitionScanner getCMakePartitionScanner() {
        if (this.fPartitionScanner == null) {
            this.fPartitionScanner = new CMakePartitionScanner();
        }
        return this.fPartitionScanner;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return CMakeEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void logInfo(Object obj, String message) {
        CMakeEditorPlugin.log(obj, 3, 1, message, null);
    }

    public static void logError(Object obj, Throwable e) {
        CMakeEditorPlugin.log(obj, 4, 4, e.getMessage(), e);
    }

    public static void logError(Object obj, String message, Throwable e) {
        CMakeEditorPlugin.log(obj, 3, 4, message, e);
    }

    private static void log(Object obj, int callLevel, int severity, String message, Throwable e) {
        StringBuilder msg = new StringBuilder();
        msg.append(ClassUtils.getShortClassName(obj instanceof Class ? (Class<?>)obj : obj.getClass()));
        msg.append(".");
        msg.append(ClassUtils.getMethodName((int)callLevel));
        msg.append(": ");
        if (message != null) {
            msg.append(message);
        }
        Status status = new Status(severity, PLUGIN_ID, severity, msg.toString(), e);
        plugin.getLog().log((IStatus)status);
    }

    public static String getResourceString(String key) {
        return Platform.getResourceString((Bundle)plugin.getBundle(), (String)("%" + key));
    }
}

