/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor;

import com.cthing.cmakeed.ui.editor.rules.ArgsCloseRule;
import com.cthing.cmakeed.ui.editor.rules.ArgsOpenRule;
import com.cthing.cmakeed.ui.editor.rules.BracketCommentRule;
import com.cthing.cmakeed.ui.editor.rules.CMakeCommandRule;
import com.cthing.cmakeed.ui.editor.rules.CMakePropertyRule;
import com.cthing.cmakeed.ui.editor.rules.CMakeReservedWordRule;
import com.cthing.cmakeed.ui.editor.rules.CMakeUserVariableRule;
import com.cthing.cmakeed.ui.editor.rules.CMakeVariableRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class CMakePartitionScanner
extends RuleBasedPartitionScanner {
    public static final String COMMENT_CONTENT_TYPE = "__comment";
    public static final String VARREF_CONTENT_TYPE = "__varref";
    public static final String STRING_CONTENT_TYPE = "__string";
    public static final String COMMAND_CONTENT_TYPE = "__command";
    public static final String DEPRECATED_COMMAND_CONTENT_TYPE = "__dep_command";
    public static final String ARGS_OPEN_CONTENT_TYPE = "__args_open";
    public static final String ARGS_CLOSE_CONTENT_TYPE = "__args_close";
    public static final String CMAKE_DEFINED_VARIABLE_CONTENT_TYPE = "__variable";
    public static final String PROPERTY_CONTENT_TYPE = "__property";
    public static final String RESERVED_WORD_CONTENT_TYPE = "__reservedword";
    public static final String USER_VARIABLE_CONTENT_TYPE = "__uservariable";
    private CMakeUserVariableRule userVariableRule = new CMakeUserVariableRule((IToken)new Token((Object)"__uservariable"));
    private CMakeUserVariableRule variableReference = new CMakeUserVariableRule((IToken)new Token((Object)"__uservariable"));
    public static final String[] CMAKE_CONTENT_TYPES = new String[]{"__dftl_partition_content_type", "__comment", "__varref", "__string", "__command", "__dep_command", "__args_open", "__args_close", "__variable", "__property", "__reservedword", "__uservariable"};

    public CMakePartitionScanner() {
        IPredicateRule[] preds = new IPredicateRule[]{new BracketCommentRule(), new EndOfLineRule("#", (IToken)new Token((Object)COMMENT_CONTENT_TYPE)), new CMakeCommandRule((IToken)new Token((Object)COMMAND_CONTENT_TYPE), false), new CMakeCommandRule((IToken)new Token((Object)DEPRECATED_COMMAND_CONTENT_TYPE), true), new ArgsOpenRule((IToken)new Token((Object)ARGS_OPEN_CONTENT_TYPE)), new SingleLineRule("@", "@", (IToken)new Token((Object)VARREF_CONTENT_TYPE)), new SingleLineRule("\"", "\"", (IToken)new Token((Object)STRING_CONTENT_TYPE)), new CMakePropertyRule((IToken)new Token((Object)PROPERTY_CONTENT_TYPE), false), new CMakeVariableRule((IToken)new Token((Object)CMAKE_DEFINED_VARIABLE_CONTENT_TYPE), false), new CMakeReservedWordRule((IToken)new Token((Object)RESERVED_WORD_CONTENT_TYPE), false), this.userVariableRule, this.variableReference, new ArgsCloseRule((IToken)new Token((Object)ARGS_CLOSE_CONTENT_TYPE))};
        this.setPredicateRules(preds);
    }

    public void removeUserVariableRule() {
        IPredicateRule[] preds = new IPredicateRule[]{new BracketCommentRule(), new EndOfLineRule("#", (IToken)new Token((Object)COMMENT_CONTENT_TYPE)), new CMakeCommandRule((IToken)new Token((Object)COMMAND_CONTENT_TYPE), false), new CMakeCommandRule((IToken)new Token((Object)DEPRECATED_COMMAND_CONTENT_TYPE), true), new ArgsOpenRule((IToken)new Token((Object)ARGS_OPEN_CONTENT_TYPE)), new SingleLineRule("\"", "\"", (IToken)new Token((Object)STRING_CONTENT_TYPE)), new CMakePropertyRule((IToken)new Token((Object)PROPERTY_CONTENT_TYPE), false), new CMakeVariableRule((IToken)new Token((Object)CMAKE_DEFINED_VARIABLE_CONTENT_TYPE), false), new CMakeReservedWordRule((IToken)new Token((Object)RESERVED_WORD_CONTENT_TYPE), false), new ArgsCloseRule((IToken)new Token((Object)ARGS_CLOSE_CONTENT_TYPE))};
        this.setPredicateRules(preds);
    }

    public void setDefaultScannerRules() {
        IPredicateRule[] preds = new IPredicateRule[]{new BracketCommentRule(), new EndOfLineRule("#", (IToken)new Token((Object)COMMENT_CONTENT_TYPE)), new CMakeCommandRule((IToken)new Token((Object)COMMAND_CONTENT_TYPE), false), new CMakeCommandRule((IToken)new Token((Object)DEPRECATED_COMMAND_CONTENT_TYPE), true), new ArgsOpenRule((IToken)new Token((Object)ARGS_OPEN_CONTENT_TYPE)), new SingleLineRule("\"", "\"", (IToken)new Token((Object)STRING_CONTENT_TYPE)), new CMakePropertyRule((IToken)new Token((Object)PROPERTY_CONTENT_TYPE), false), new CMakeVariableRule((IToken)new Token((Object)CMAKE_DEFINED_VARIABLE_CONTENT_TYPE), false), new CMakeReservedWordRule((IToken)new Token((Object)RESERVED_WORD_CONTENT_TYPE), false), this.userVariableRule, new ArgsCloseRule((IToken)new Token((Object)ARGS_CLOSE_CONTENT_TYPE))};
        this.setPredicateRules(preds);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public static boolean isUserVariable(String contentType) {
        return USER_VARIABLE_CONTENT_TYPE.equals(contentType);
    }

    public static boolean isDefault(String contentType) {
        return "__dftl_partition_content_type".equals(contentType);
    }

    public static boolean isComment(String contentType) {
        return COMMENT_CONTENT_TYPE.equals(contentType);
    }

    public static boolean isVariable(String contentType) {
        return VARREF_CONTENT_TYPE.equals(contentType);
    }

    public static boolean isString(String contentType) {
        return STRING_CONTENT_TYPE.equals(contentType);
    }

    public static boolean isAnyCommand(String contentType) {
        return CMakePartitionScanner.isCommand(contentType) || CMakePartitionScanner.isDepCommand(contentType);
    }

    public static boolean isCommand(String contentType) {
        return COMMAND_CONTENT_TYPE.equals(contentType);
    }

    public static boolean isProperty(String contentType) {
        return PROPERTY_CONTENT_TYPE.equals(contentType);
    }

    public static boolean isCMakeVariable(String contentType) {
        return CMAKE_DEFINED_VARIABLE_CONTENT_TYPE.equals(contentType);
    }

    public static boolean isReservedWord(String contentType) {
        return RESERVED_WORD_CONTENT_TYPE.equals(contentType);
    }

    public static boolean isDepCommand(String contentType) {
        return DEPRECATED_COMMAND_CONTENT_TYPE.equals(contentType);
    }

    public static boolean isArgsOpen(String contentType) {
        return ARGS_OPEN_CONTENT_TYPE.equals(contentType);
    }

    public static boolean isArgsClose(String contentType) {
        return ARGS_CLOSE_CONTENT_TYPE.equals(contentType);
    }
}

