/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.srcfinder;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.ISourceFinder;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.ProgramRelativePathSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.IPersistableSourceLocator2;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class CSourceFinder
implements ISourceFinder,
ILaunchConfigurationListener,
ILaunchesListener {
    private IBinary fBinary;
    private ISourceLookupDirector fLaunchLocator;
    private Map<String, ISourceLocator> fConfigLocators = Collections.synchronizedMap(new HashMap());
    private ProgramRelativePathSourceContainer fRelativePathContainer;

    public CSourceFinder(IBinary binary) {
        assert (binary != null);
        this.fBinary = binary;
        this.fRelativePathContainer = new ProgramRelativePathSourceContainer(binary);
        ILaunchManager lmgr = DebugPlugin.getDefault().getLaunchManager();
        lmgr.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        lmgr.addLaunchListener((ILaunchesListener)this);
    }

    public synchronized String toLocalPath(String compilationPath) {
        try {
            Object foundElement = null;
            if (this.fLaunchLocator == null) {
                ILaunch[] launches;
                ILaunchManager lmgr = DebugPlugin.getDefault().getLaunchManager();
                ILaunch[] iLaunchArray = launches = lmgr.getLaunches();
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    ISourceLocator launchLocator;
                    ILaunch launch = iLaunchArray[n2];
                    ILaunchConfiguration config = launch.getLaunchConfiguration();
                    if (config != null && this.isMatch(config) && (launchLocator = launch.getSourceLocator()) instanceof ISourceLookupDirector) {
                        this.fLaunchLocator = (ISourceLookupDirector)launchLocator;
                        break;
                    }
                    ++n2;
                }
                if (this.fLaunchLocator == null) {
                    iLaunchArray = lmgr.getLaunchConfigurations();
                    n = iLaunchArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        ILaunch config = iLaunchArray[n2];
                        if (this.isMatch((ILaunchConfiguration)config)) {
                            String configName = config.getName();
                            ISourceLocator configLocator = this.fConfigLocators.get(configName);
                            if (configLocator == null) {
                                configLocator = CSourceFinder.getLocator((ILaunchConfiguration)config);
                                this.fConfigLocators.put(configName, configLocator);
                            }
                            if (configLocator instanceof ISourceLookupDirector) {
                                this.fLaunchLocator = (ISourceLookupDirector)configLocator;
                                break;
                            }
                        }
                        ++n2;
                    }
                }
            }
            if (this.fLaunchLocator != null) {
                foundElement = this.fLaunchLocator.getSourceElement((Object)compilationPath);
            } else {
                Object[] elements = this.fRelativePathContainer.findSourceElements(compilationPath);
                if (elements.length > 0) {
                    assert (elements.length == 1);
                    foundElement = elements[0];
                }
            }
            if (this.fLaunchLocator == null && foundElement == null) {
                CSourceLookupDirector locator = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector();
                foundElement = locator.getSourceElement(compilationPath);
            }
            return CSourceFinder.foundElementToPath(foundElement);
        }
        catch (CoreException exc) {
            CDebugCorePlugin.log(exc);
            return null;
        }
    }

    public String toLocalPath(IAdaptable _launch, String compilationPath) {
        Object locator;
        Object foundElement = null;
        ILaunch launch = (ILaunch)_launch.getAdapter(ILaunch.class);
        if (launch != null && (locator = launch.getSourceLocator()) instanceof ISourceLookupDirector) {
            foundElement = ((ISourceLookupDirector)locator).getSourceElement((Object)compilationPath);
        }
        if (foundElement == null) {
            locator = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector();
            foundElement = locator.getSourceElement((Object)compilationPath);
        }
        return CSourceFinder.foundElementToPath(foundElement);
    }

    private static String foundElementToPath(Object foundElement) {
        if (foundElement != null) {
            try {
                File file;
                IPath path;
                URI uri;
                if (foundElement instanceof IFile) {
                    File file2;
                    IPath path2 = ((IFile)foundElement).getLocation();
                    if (path2 != null && (file2 = path2.toFile()) != null) {
                        return file2.getCanonicalPath();
                    }
                } else if (foundElement instanceof LocalFileStorage) {
                    File file3 = ((LocalFileStorage)foundElement).getFile();
                    if (file3 != null) {
                        return file3.getCanonicalPath();
                    }
                } else if (foundElement instanceof ExternalTranslationUnit && (uri = ((ExternalTranslationUnit)foundElement).getLocationURI()) != null && (path = URIUtil.toPath((URI)uri)) != null && (file = path.toFile()) != null) {
                    return file.getCanonicalPath();
                }
            }
            catch (IOException e) {
                CDebugCorePlugin.log(e);
            }
        }
        return null;
    }

    private boolean isMatch(ILaunchConfiguration config) {
        IResource resource = (IResource)this.fBinary.getAdapter(IResource.class);
        if (resource != null) {
            String binaryPath = resource.getFullPath().toString();
            try {
                IFile file;
                Path path;
                String projectNameConfig = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                String programNameConfig = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                IProject project = resource.getProject();
                if (project != null && project.getName().equals(projectNameConfig) && !(path = new Path(programNameConfig = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programNameConfig))).isEmpty() && (file = project.getFile((IPath)path)) != null) {
                    String fullPath = file.getFullPath().toString();
                    return fullPath.equals(binaryPath);
                }
            }
            catch (CoreException e) {
                CDebugCorePlugin.log(e);
            }
        }
        return false;
    }

    private static ISourceLocator getLocator(ILaunchConfiguration config) throws CoreException {
        String type = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
        if (type == null) {
            type = config.getType().getSourceLocatorId();
        }
        if (type != null) {
            IPersistableSourceLocator locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(type);
            String memento = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            if (memento == null) {
                locator.initializeDefaults(config);
            } else if (locator instanceof IPersistableSourceLocator2) {
                ((IPersistableSourceLocator2)locator).initializeFromMemento(memento, config);
            } else {
                locator.initializeFromMemento(memento);
            }
            return locator;
        }
        return null;
    }

    public void launchConfigurationAdded(ILaunchConfiguration config) {
    }

    public synchronized void launchConfigurationChanged(ILaunchConfiguration config) {
        if (config.isWorkingCopy()) {
            return;
        }
        this.fConfigLocators.remove(config.getName());
        if (this.fLaunchLocator != null && this.fLaunchLocator.getLaunchConfiguration().getName() == config.getName()) {
            this.fLaunchLocator = null;
        }
    }

    public synchronized void launchConfigurationRemoved(ILaunchConfiguration config) {
        if (config.isWorkingCopy()) {
            return;
        }
        this.fConfigLocators.remove(config.getName());
        if (this.fLaunchLocator != null && this.fLaunchLocator.getLaunchConfiguration().getName() == config.getName()) {
            this.fLaunchLocator = null;
        }
    }

    public synchronized void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch.getSourceLocator() == this.fLaunchLocator) {
                this.fLaunchLocator = null;
                return;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchesAdded(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            if (config != null && this.isMatch(config)) {
                CSourceFinder cSourceFinder = this;
                synchronized (cSourceFinder) {
                    this.fLaunchLocator = null;
                }
            }
            ++n2;
        }
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void dispose() {
        ILaunchManager lmgr = DebugPlugin.getDefault().getLaunchManager();
        lmgr.removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        lmgr.removeLaunchListener((ILaunchesListener)this);
    }
}

