/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.ProjectDescriptionReader;
import com.espressif.idf.ui.IDFConsole;
import com.espressif.idf.ui.UIPlugin;
import com.espressif.idf.ui.tracing.ClientWorker;
import com.espressif.idf.ui.tracing.Messages;
import com.espressif.idf.ui.tracing.TclClient;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.framework.Bundle;

public class AppLvlTracingDialog
extends TitleAreaDialog {
    private Text outFilePath;
    private Spinner pollTimer;
    private Spinner traceSize;
    private Spinner stopTmo;
    private Button waitForHalt;
    private Spinner skipSize;
    private Button browseBtn;
    private TclClient tclClient;
    private String pathToProject;
    private Button browseParseScriptBtn;
    private Text openocdLog;
    private Button startParseBtn;
    private MessageConsoleStream console;
    private Text parseScritPath;
    private String elfFilePath;
    private Text parseCommandTxt;
    private Button startButton;
    private boolean isOutputDirectoryValid;
    private boolean isDumpFileExists;

    public AppLvlTracingDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.AppLvlTracingDialog_Title);
        this.setTitleImage(UIPlugin.getImage("icons/espressif_logo.png"));
        this.setMessage(Messages.AppLvlTracingDialog_Description);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridData gdContainer = new GridData(4, 4, true, true, 1, 1);
        container.setLayoutData((Object)gdContainer);
        container.setLayout((Layout)new GridLayout(4, false));
        Label pollTimerLbl = new Label(container, 0);
        pollTimerLbl.setText(Messages.AppLvlTracing_PollPeriod);
        this.pollTimer = new Spinner(container, 2048);
        this.pollTimer.setMinimum(0);
        this.pollTimer.setMaximum(Integer.MAX_VALUE);
        Composite unitsOneLblComp = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        unitsOneLblComp.setLayout((Layout)layout);
        Label pollTimerUnitsLbl = new Label(unitsOneLblComp, 0);
        this.waitForHalt = new Button(unitsOneLblComp, 32);
        this.waitForHalt.setText(Messages.AppLvlTracing_WaitForHalt);
        pollTimerUnitsLbl.setText("milliseconds");
        new Label(container, 0);
        Label traceSizeLbl = new Label(container, 0);
        traceSizeLbl.setText(Messages.AppLvlTracing_MaxTraceSize);
        this.traceSize = new Spinner(container, 2048);
        this.traceSize.setMinimum(-1);
        this.traceSize.setMaximum(Integer.MAX_VALUE);
        this.traceSize.setSelection(-1);
        Label traceSizeUnitsLbl = new Label(container, 0);
        traceSizeUnitsLbl.setText("bytes");
        new Label(container, 0);
        Label timeoutLbl = new Label(container, 0);
        timeoutLbl.setText(Messages.AppLvlTracing_StopTmo);
        this.stopTmo = new Spinner(container, 2048);
        this.stopTmo.setMinimum(-1);
        this.stopTmo.setMaximum(Integer.MAX_VALUE);
        this.stopTmo.setSelection(-1);
        Label timeoutUnitsLbl = new Label(container, 0);
        timeoutUnitsLbl.setText("seconds");
        new Label(container, 0);
        Label bytesToSkipLbl = new Label(container, 0);
        bytesToSkipLbl.setText(Messages.AppLvlTracing_BytesToSKip);
        this.skipSize = new Spinner(container, 2048);
        this.skipSize.setMinimum(0);
        this.skipSize.setMaximum(Integer.MAX_VALUE);
        Label bytesUnitsLbl = new Label(container, 0);
        bytesUnitsLbl.setText("bytes");
        new Label(container, 0);
        Label outFileLbl = new Label(container, 0);
        outFileLbl.setText(Messages.AppLvlTracing_OutFile);
        this.outFilePath = new Text(container, 2048);
        this.outFilePath.setText(this.pathToProject);
        this.outFilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                File dumpFile = new File(AppLvlTracingDialog.this.outFilePath.getText().replace("file://", ""));
                AppLvlTracingDialog.this.checkIfDirectoryIsValid(dumpFile);
                AppLvlTracingDialog.this.checkIfDumpFileExists(dumpFile);
                if (AppLvlTracingDialog.this.isDumpFileExists && AppLvlTracingDialog.this.isOutputDirectoryValid) {
                    AppLvlTracingDialog.this.startButton.setEnabled(true);
                    AppLvlTracingDialog.this.startParseBtn.setEnabled(true);
                    AppLvlTracingDialog.this.setErrorMessage(null);
                    AppLvlTracingDialog.this.setMessage(Messages.AppLvlTracingDialog_Description);
                    AppLvlTracingDialog.this.parseCommandTxt.setText(AppLvlTracingDialog.this.getDefaultParseCommand());
                } else if (AppLvlTracingDialog.this.isOutputDirectoryValid) {
                    AppLvlTracingDialog.this.startButton.setEnabled(true);
                    AppLvlTracingDialog.this.setErrorMessage(null);
                }
            }
        });
        GridData gdOutFile = new GridData(4, 4, true, false, 2, 1);
        this.outFilePath.setLayoutData((Object)gdOutFile);
        this.browseBtn = new Button(container, 0);
        this.browseBtn.setText(Messages.AppLvlTracingDialog_Browse);
        this.browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppLvlTracingDialog.this.browseButtonSelected(Messages.AppLvlTracingDialog_OutputFileDirLbl, AppLvlTracingDialog.this.outFilePath);
            }
        });
        Label parseDumpFileLbl = new Label(container, 0);
        parseDumpFileLbl.setText(Messages.AppLvlTracing_TraceScript);
        this.parseScritPath = new Text(container, 2048);
        GridData gdParseScriptPath = new GridData(4, 4, true, false, 2, 1);
        this.parseScritPath.setLayoutData((Object)gdParseScriptPath);
        this.parseScritPath.setText(IDFUtil.getIDFPath() + File.separator + "tools" + File.separator + "esp_app_trace" + File.separator + "logtrace_proc.py");
        this.parseScritPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!new File(AppLvlTracingDialog.this.parseScritPath.getText()).exists()) {
                    AppLvlTracingDialog.this.startParseBtn.setEnabled(false);
                    AppLvlTracingDialog.this.setErrorMessage(AppLvlTracingDialog.this.parseScritPath.getText() + Messages.AppLvlTracing_NotValidScriptFilePath);
                } else if (AppLvlTracingDialog.this.isDumpFileExists) {
                    AppLvlTracingDialog.this.startParseBtn.setEnabled(true);
                    AppLvlTracingDialog.this.parseCommandTxt.setText(AppLvlTracingDialog.this.getDefaultParseCommand());
                    AppLvlTracingDialog.this.setErrorMessage(null);
                } else {
                    AppLvlTracingDialog.this.setErrorMessage(null);
                }
            }
        });
        this.browseParseScriptBtn = new Button(container, 0);
        this.browseParseScriptBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(AppLvlTracingDialog.this.getParentShell(), 4096);
                fd.setText(Messages.AppLvlTracing_ScriptBrowseLbl);
                fd.setFilterExtensions(new String[]{".py"});
                AppLvlTracingDialog.this.parseScritPath.setText(fd.open());
            }
        });
        this.browseParseScriptBtn.setText(Messages.AppLvlTracingDialog_Browse);
        Label startParseLbl = new Label(container, 0);
        startParseLbl.setText(Messages.AppLvlTracing_StartParsingCommandLbl);
        this.parseCommandTxt = new Text(container, 2304);
        GridData gdParseCommandTxt = new GridData(4, 4, true, false, 2, 1);
        gdParseCommandTxt.widthHint = 500;
        this.parseCommandTxt.setLayoutData((Object)gdParseCommandTxt);
        this.parseCommandTxt.setText(this.getDefaultParseCommand());
        this.startParseBtn = new Button(container, 0);
        this.startParseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppLvlTracingDialog.this.activateTracingConsoleView();
                AppLvlTracingDialog.this.runTraceCommand();
            }
        });
        this.startParseBtn.setText(Messages.AppLvlTracing_StartParse);
        new Label(container, 0);
        this.openocdLog = new Text(container, 778);
        this.openocdLog.setText("Output will appear here");
        GridData gdOpenocdLog = new GridData(4, 4, true, false, 2, 1);
        gdOpenocdLog.widthHint = 500;
        gdOpenocdLog.heightHint = 306;
        this.openocdLog.setLayoutData((Object)gdOpenocdLog);
        return area;
    }

    private void checkIfDumpFileExists(File dumpFile) {
        if (dumpFile.exists()) {
            this.isDumpFileExists = true;
        } else {
            this.startParseBtn.setEnabled(false);
            this.setMessage(Messages.AppLvlTracing_DumpFileNotExistsInfo, 1);
            this.isDumpFileExists = false;
        }
    }

    private void checkIfDirectoryIsValid(File dumpFile) {
        File dir = new File(dumpFile.getParent());
        if (dir.isDirectory()) {
            this.isOutputDirectoryValid = true;
        } else {
            this.startParseBtn.setEnabled(false);
            this.startButton.setEnabled(false);
            this.setErrorMessage(dumpFile.getParent() + Messages.AppLvlTracing_NotValidDirectoryPath);
            this.isOutputDirectoryValid = false;
        }
    }

    private void runTraceCommand() {
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(this.parseCommandTxt.getText().split(" ")));
            HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
            IStatus status = processRunner.runInBackground(arguments, (IPath)Path.ROOT, environment);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Status can't be null", null));
                return;
            }
            this.console.println(status.getMessage());
            this.console.println();
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
        }
    }

    private String getDefaultParseCommand() {
        if (this.parseScritPath == null || this.outFilePath == null || this.elfFilePath == null) {
            return "";
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(IDFUtil.getIDFPythonEnvPath());
        arguments.add(this.parseScritPath.getText());
        arguments.add(this.outFilePath.getText().replace("file://", ""));
        arguments.add(this.elfFilePath);
        return String.join((CharSequence)" ", arguments);
    }

    private void activateTracingConsoleView() {
        URL imageUrl = FileLocator.find((Bundle)UIPlugin.getDefault().getBundle(), (IPath)new Path("icons/ESP-IDF_Application_Level_Tracing.png"));
        this.console = new IDFConsole().getConsoleStream(Messages.AppLvlTracing_ConsoleName, imageUrl, false);
    }

    private void browseButtonSelected(String title, Text text) {
        DirectoryDialog dialog = new DirectoryDialog(this.getParentShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        str = dialog.open();
        str = str.replace(File.separator, "/");
        str = this.wrapOutputFilePath(str);
        this.outFilePath.setText(str);
    }

    private String wrapOutputFilePath(String baseFilePath) {
        baseFilePath = (String)baseFilePath + "/trace.log";
        baseFilePath = ((String)baseFilePath).replace("/", "//");
        baseFilePath = "file://" + (String)baseFilePath;
        return baseFilePath;
    }

    public void setProjectPath(IResource project) {
        this.pathToProject = project.getLocation().toString();
        IFile elfFile = new ProjectDescriptionReader(project.getProject()).getAppElfFile();
        this.elfFilePath = elfFile == null ? null : elfFile.getLocation().toString();
        this.pathToProject = this.wrapOutputFilePath(this.pathToProject);
    }

    protected void okPressed() {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.startButton = this.createButton(parent, 0, "Start", true);
        this.startButton.addListener(13, new Listener(){
            private ClientWorker clientWorker;

            public void handleEvent(Event event) {
                if (AppLvlTracingDialog.this.startButton.getText().contentEquals("Start")) {
                    String waitForHaltStringValue = AppLvlTracingDialog.this.waitForHalt.getSelection() ? "1" : "0";
                    AppLvlTracingDialog.this.tclClient = new TclClient();
                    AppLvlTracingDialog.this.tclClient.startTracing(new String[]{AppLvlTracingDialog.this.outFilePath.getText(), AppLvlTracingDialog.this.pollTimer.getText(), AppLvlTracingDialog.this.traceSize.getText(), AppLvlTracingDialog.this.stopTmo.getText(), waitForHaltStringValue, AppLvlTracingDialog.this.skipSize.getText()});
                    AppLvlTracingDialog.this.openocdLog.setText("");
                    this.clientWorker = new ClientWorker(AppLvlTracingDialog.this.tclClient, AppLvlTracingDialog.this.openocdLog);
                    Thread thread = new Thread(this.clientWorker);
                    thread.start();
                    AppLvlTracingDialog.this.startButton.setText("Stop");
                } else {
                    AppLvlTracingDialog.this.tclClient.stopTracing();
                    Thread thread = new Thread(this.clientWorker);
                    thread.start();
                    AppLvlTracingDialog.this.startButton.setText("Start");
                    AppLvlTracingDialog.this.outFilePath.notifyListeners(24, null);
                    AppLvlTracingDialog.this.parseScritPath.notifyListeners(24, null);
                }
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.outFilePath.notifyListeners(24, null);
    }

    protected Point getInitialSize() {
        return new Point(800, 700);
    }

    protected boolean isResizable() {
        return true;
    }
}

