/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.installcomponents.handler;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.handlers.EclipseHandler;
import com.espressif.idf.ui.installcomponents.InstallComponentsEditor;
import com.espressif.idf.ui.installcomponents.deserializer.ComponentsDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.stream.JsonReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class InstallIDFComponentsHandler
extends AbstractHandler {
    private static final String API_URL = "https://api.components.espressif.com/components";
    private static int TOTAL_RECORDS_TO_FETCH = 100;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            URL url = new URL(API_URL.concat("?per_page=".concat(String.valueOf(TOTAL_RECORDS_TO_FETCH))));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("accept", "application/json");
            InputStream responseStream = connection.getInputStream();
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(responseStream));
            Gson gson = new GsonBuilder().registerTypeAdapter(ArrayList.class, (Object)new ComponentsDeserializer()).setPrettyPrinting().disableHtmlEscaping().create();
            JsonArray jsonArray = (JsonArray)gson.fromJson(jsonReader, JsonArray.class);
            IProject selectedProject = EclipseHandler.getSelectedResource((IEvaluationContext)event.getApplicationContext()).getProject();
            IFile file = selectedProject.getFolder("build").getFile("components.json");
            FileWriter fileWriter = new FileWriter(file.getLocation().toFile());
            fileWriter.write(jsonArray.toString());
            fileWriter.close();
            this.launchEditor(file);
        }
        catch (Exception e) {
            Logger.log((Exception)e);
        }
        return null;
    }

    private void launchEditor(final IFile file) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow activeww = EclipseHandler.getActiveWorkbenchWindow();
                try {
                    IDE.openEditor((IWorkbenchPage)activeww.getActivePage(), (IFile)file, (String)InstallComponentsEditor.EDITOR_ID);
                }
                catch (PartInitException e) {
                    Logger.log((Exception)((Object)e));
                }
            }
        });
    }
}

