/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.dialogs;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.BigIntDecoder;
import com.espressif.idf.core.util.EspToolCommands;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.dialogs.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class WriteFlashDialog
extends TitleAreaDialog {
    private static final String DEFAULT_BIN_NAME = "nvs.bin";
    private static final String DEFAULT_OFFSET = "0x8000";
    private static final String[] EXTENSIONS = new String[]{"*.bin"};
    private Combo comPortsCombo;
    private Text deviceInformationText;
    private String[] ports = new String[0];
    private EspToolCommands espToolCommands;
    private Text offsetText;
    private Text binPathText;
    private IProject project;
    private boolean doChangeErrorMessage = false;

    public WriteFlashDialog(Shell parentShell) {
        super(parentShell);
        try {
            this.ports = SerialPort.list();
            this.espToolCommands = new EspToolCommands();
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        GridData comboLayoutData = new GridData();
        comboLayoutData.grabExcessHorizontalSpace = true;
        comboLayoutData.horizontalAlignment = 4;
        comboLayoutData.horizontalSpan = 2;
        Label comPortsLabel = new Label(container, 0);
        comPortsLabel.setText(Messages.EraseFlashDialog_ComPortLabel);
        this.comPortsCombo = new Combo(container, 8);
        String[] stringArray = this.ports;
        int n = this.ports.length;
        int n2 = 0;
        while (n2 < n) {
            String port = stringArray[n2];
            this.comPortsCombo.add(port);
            ++n2;
        }
        this.comPortsCombo.setLayoutData((Object)comboLayoutData);
        Label binPathLabel = new Label(container, 0);
        binPathLabel.setText(Messages.WriteFlashDialog_Bin_Path_Lbl);
        this.binPathText = new Text(container, 2308);
        this.binPathText.setLayoutData((Object)new GridData(768));
        Button browseButton = new Button(container, 8);
        browseButton.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        browseButton.setText(Messages.WriteFlashDialog_Browse_Btn);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog fileSelectionDialog = new FileDialog(WriteFlashDialog.this.getParentShell());
                fileSelectionDialog.setFilterExtensions(EXTENSIONS);
                fileSelectionDialog.setFilterPath(WriteFlashDialog.this.project.getLocationURI().getPath());
                String selectedFilePath = fileSelectionDialog.open();
                if (selectedFilePath != null && !selectedFilePath.isEmpty()) {
                    WriteFlashDialog.this.binPathText.setText(selectedFilePath);
                }
            }
        });
        Label offsetLabel = new Label(container, 0);
        offsetLabel.setText(Messages.WriteFlashDialog_Offset_Lbl);
        this.offsetText = new Text(container, 2308);
        this.offsetText.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.deviceInformationText = new Text(container, 2824);
        this.deviceInformationText.setText(Messages.EraseFlashDialog_DeviceInformationAreaInitialText);
        this.deviceInformationText.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.comPortsCombo.addSelectionListener((SelectionListener)new ComPortSelectionListener());
        this.binPathText.addListener(24, e -> this.getButton(0).setEnabled(this.validateInputs()));
        this.offsetText.addListener(24, e -> this.getButton(0).setEnabled(this.validateInputs()));
        return container;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.WriteFlashDialog_Title);
        this.setMessage(Messages.WriteFlashDialog_Information_Msg, 1);
        this.setDefaults();
    }

    private void setDefaults() {
        String defaultPathToBin;
        IStructuredSelection sel;
        Object element;
        this.offsetText.setText(DEFAULT_OFFSET);
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && (element = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            IResource elem = (IResource)element;
            this.project = elem.getProject();
        }
        if (new File(defaultPathToBin = this.project.getFile(DEFAULT_BIN_NAME).getLocation().toOSString()).exists()) {
            this.binPathText.setText(defaultPathToBin);
        } else {
            this.binPathText.setMessage(defaultPathToBin);
        }
        ILaunchBarManager barManager = (ILaunchBarManager)IDFCorePlugin.getService(ILaunchBarManager.class);
        try {
            String serialPortFromTarget = barManager.getActiveLaunchTarget().getAttribute("com.espressif.idf.launch.serial.core.serialPort", "");
            this.comPortsCombo.setText(serialPortFromTarget);
            if (!serialPortFromTarget.isEmpty()) {
                this.comPortsCombo.notifyListeners(13, null);
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        this.doChangeErrorMessage = true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.WriteFlashDialog_Title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.WriteFlashDialog_Flash_Btn_Lbl, true);
        this.getButton(0).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    public boolean close() {
        if (this.espToolCommands.checkActiveWriteFlashProcess()) {
            boolean canClose = MessageDialog.openQuestion((Shell)this.getParentShell(), (String)Messages.EraseFlashDialog_EraseFlashInProcessMessageTitle, (String)Messages.EraseFlashDialog_EraseFlashInProcessMessageQuestion);
            if (!canClose) {
                return false;
            }
            this.espToolCommands.killWriteFlashProcess();
        }
        return super.close();
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.getButton(0).setEnabled(false);
        this.deviceInformationText.setText(Messages.WriteFlashDialog_WritingBinsToFlashMsg0);
        String selectedPort = this.comPortsCombo.getText();
        this.comPortsCombo.setEnabled(false);
        this.deviceInformationText.setText("");
        String binsPathString = this.binPathText.getText();
        String offString = this.offsetText.getText();
        Thread writeFlashThread = new Thread(() -> {
            try {
                String line;
                Process writeFlashProcess = this.espToolCommands.writeFlash(selectedPort, binsPathString, offString);
                InputStream targetIn = writeFlashProcess.getInputStream();
                InputStream targetErr = writeFlashProcess.getErrorStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(targetIn));
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(targetErr));
                StringBuilder errorMessage = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    String toWrite = line;
                    Display.getDefault().asyncExec(() -> {
                        if (!this.deviceInformationText.isDisposed()) {
                            this.deviceInformationText.append(toWrite + StringUtil.LINE_SEPARATOR);
                        }
                    });
                }
                while ((line = errorReader.readLine()) != null) {
                    errorMessage.append(line).append(System.lineSeparator());
                }
                int exitCode = writeFlashProcess.waitFor();
                if (exitCode != 0 || errorMessage.length() > 0) {
                    String errorMsg = errorMessage.toString();
                    Display.getDefault().asyncExec(() -> {
                        if (!this.deviceInformationText.isDisposed()) {
                            this.deviceInformationText.append(Messages.WriteFlashDialog_ErrorExitCodeMsg + exitCode + StringUtil.LINE_SEPARATOR);
                            if (!errorMsg.isEmpty()) {
                                this.deviceInformationText.append(Messages.WriteFlashDialog_ErrorOutputMsg + errorMsg + StringUtil.LINE_SEPARATOR);
                            }
                        }
                    });
                }
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
            catch (InterruptedException e) {
                Logger.log((Exception)e);
            }
            catch (Exception e) {
                Logger.log((Exception)e);
            }
            Display.getDefault().syncExec(() -> {
                if (!this.comPortsCombo.isDisposed()) {
                    this.comPortsCombo.setEnabled(true);
                }
            });
        });
        writeFlashThread.start();
    }

    protected Point getInitialSize() {
        return new Point(450, 500);
    }

    private boolean validateInputs() {
        boolean validateStatus = true;
        if (this.comPortsCombo.getText().isEmpty()) {
            validateStatus = false;
            this.setErrorMessage(Messages.WriteFlashDialog_SerialPortErrMsg);
        }
        if (!new File(this.binPathText.getText()).exists()) {
            validateStatus = false;
            this.setErrorMessage(String.format(Messages.WriteFlashDialog_BinFileErrFormatErrMsg, this.binPathText.getText()));
        }
        try {
            BigIntDecoder.decode((String)this.offsetText.getText());
        }
        catch (NumberFormatException e) {
            validateStatus = false;
            this.setErrorMessage(Messages.WriteFlashDialog_OffsetErrMsg);
        }
        if (validateStatus) {
            this.setErrorMessage(null);
        }
        return validateStatus;
    }

    public void setErrorMessage(String newErrorMessage) {
        if (this.doChangeErrorMessage) {
            super.setErrorMessage(newErrorMessage);
        }
    }

    private class ComPortSelectionListener
    extends SelectionAdapter
    implements Runnable {
        private String selectedPort;

        private ComPortSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            WriteFlashDialog.this.getButton(0).setEnabled(WriteFlashDialog.this.validateInputs());
            this.selectedPort = ((Combo)event.getSource()).getText();
            try {
                WriteFlashDialog.this.deviceInformationText.setText(Messages.EraseFlashDialog_LoadingMessage);
                Thread infoThread = new Thread(this);
                infoThread.start();
            }
            catch (Exception exception) {
                Logger.log((Exception)exception);
            }
        }

        @Override
        public void run() {
            try {
                Process chipInfoProcess = WriteFlashDialog.this.espToolCommands.chipInformation(this.selectedPort);
                InputStream targetIn = chipInfoProcess.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(targetIn));
                int readCharInt = 0;
                while ((readCharInt = bufferedReader.read()) != -1) {
                    char charToWrite = (char)readCharInt;
                    Display.getDefault().asyncExec(() -> {
                        if (!WriteFlashDialog.this.deviceInformationText.isDisposed()) {
                            WriteFlashDialog.this.deviceInformationText.append(Character.toString(charToWrite));
                        }
                    });
                }
            }
            catch (Exception e) {
                Logger.log((Exception)e);
            }
        }
    }
}

