/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.dsf;

import com.espressif.idf.debug.gdbjtag.openocd.Activator;
import com.espressif.idf.debug.gdbjtag.openocd.Configuration;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.dsf.GnuMcuGdbServerBackend;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.osgi.framework.BundleContext;

public class GdbServerBackend
extends GnuMcuGdbServerBackend {
    protected int fGdbServerLaunchDefaultTimeout = 25;
    protected boolean fDoStartGdbClient;

    public GdbServerBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.GdbServerBackend(" + String.valueOf(session) + "," + lc.getName() + ")");
        }
    }

    public void initialize(final RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.GdbServerBackend.initialize()");
        }
        try {
            this.fDoStartGdbServer = Configuration.getDoStartGdbServer(this.fLaunchConfiguration);
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", -1, "Cannot get configuration", (Throwable)e));
            rm.done();
            return;
        }
        try {
            this.fDoStartGdbClient = Configuration.getDoStartGdbClient(this.fLaunchConfiguration);
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", -1, "Cannot get configuration", (Throwable)e));
            rm.done();
            return;
        }
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GdbServerBackend.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.GdbServerBackend.doInitialize()");
        }
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.GdbServerBackend.shutdown()");
        }
        super.shutdown(rm);
    }

    public void destroy() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.GdbServerBackend.destroy() " + String.valueOf(Thread.currentThread()));
        }
        super.destroy();
    }

    protected BundleContext getBundleContext() {
        return Activator.getInstance().getBundle().getBundleContext();
    }

    public String[] getServerCommandLineArray() {
        String[] commandLineArray = Configuration.getGdbServerCommandLineArray(this.fLaunchConfiguration);
        return commandLineArray;
    }

    public String getServerCommandName() {
        String[] commandLineArray = this.getServerCommandLineArray();
        if (commandLineArray == null) {
            return null;
        }
        String fullCommand = commandLineArray[0];
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public int getServerLaunchTimeoutSeconds() {
        return Platform.getPreferencesService().getInt("com.espressif.idf.core", "fGdbServerLaunchTimeout", this.fGdbServerLaunchDefaultTimeout, null);
    }

    public String getServerName() {
        return "OpenOCD";
    }

    public boolean canMatchStdOut() {
        return false;
    }

    public boolean canMatchStdErr() {
        return this.fDoStartGdbClient;
    }

    public boolean matchStdErrExpectedPattern(String line) {
        return line.indexOf("Started by GNU ARM Eclipse") >= 0 || line.indexOf("Started by GNU MCU Eclipse") >= 0;
    }

    public String prepareMessageBoxText(int exitCode) {
        String body = "";
        String name = this.getServerCommandName();
        if (name == null) {
            name = "GDB Server";
        }
        String tail = "\n\nFor more details, see the " + name + " console.";
        if (body.isEmpty()) {
            return this.getServerName() + " failed with code (" + exitCode + ")." + tail;
        }
        return this.getServerName() + " failed: \n" + body + tail;
    }

    protected Process launchGdbServerProcess(String[] commandLineArray) throws CoreException {
        String openocdLoc;
        File dir = null;
        IPath path = DebugUtils.getGdbWorkingDirectory((ILaunchConfiguration)this.fLaunchConfiguration);
        if (path != null) {
            dir = new File(path.toOSString());
        }
        String[] envp = DebugUtils.getLaunchEnvironment((ILaunchConfiguration)this.fLaunchConfiguration);
        HashMap<String, String> envMap = new HashMap<String, String>();
        String[] stringArray = envp;
        int n = envp.length;
        int n2 = 0;
        while (n2 < n) {
            String env = stringArray[n2];
            int idx = env.indexOf(61);
            if (idx > 0) {
                envMap.put(env.substring(0, idx), env.substring(idx + 1));
            }
            ++n2;
        }
        ILaunchTarget activeLaunchTarget = Activator.getService(ILaunchBarManager.class).getActiveLaunchTarget();
        if (activeLaunchTarget != null && (openocdLoc = activeLaunchTarget.getAttribute("OPENOCD_USB_ADAPTER_LOCATION", null)) != null) {
            envMap.put("OPENOCD_USB_ADAPTER_LOCATION", openocdLoc);
        }
        ArrayList<CallSite> envList = new ArrayList<CallSite>();
        for (Map.Entry entry : envMap.entrySet()) {
            envList.add((CallSite)((Object)((String)entry.getKey() + "=" + (String)entry.getValue())));
        }
        return DebugUtils.exec((String[])commandLineArray, (String[])envList.toArray(new String[0]), (File)dir);
    }
}

