/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.sdk.config.core;

import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONObject;

public class KConfigMenuItem {
    private List<KConfigMenuItem> children = new ArrayList<KConfigMenuItem>();
    private String help;
    private String name;
    private KConfigMenuItem parent;
    private String title;
    private String type;
    private String id;
    private boolean isMenuConfig;

    public KConfigMenuItem(KConfigMenuItem parent) {
        this.parent = parent;
    }

    public void addChild(KConfigMenuItem item) {
        this.children.add(item);
    }

    public List<KConfigMenuItem> getChildren() {
        return this.children;
    }

    public String getHelp() {
        return this.help;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public KConfigMenuItem getParent() {
        return this.parent;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public boolean isMenuConfig() {
        return this.isMenuConfig;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void setChildren(List<KConfigMenuItem> children) {
        this.children = children;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String name) {
        this.id = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setIsMenuConfig(boolean isMenuConfig) {
        this.isMenuConfig = isMenuConfig;
    }

    public boolean isVisible(JSONObject visibleJsonMap) {
        if (visibleJsonMap == null || visibleJsonMap.isEmpty()) {
            return false;
        }
        if (this.getType() != null && this.getType().equals("menu")) {
            return this.isVisible(this.children, visibleJsonMap);
        }
        return this.isVisible(visibleJsonMap, this.getId());
    }

    private boolean isVisible(List<KConfigMenuItem> children, JSONObject visibleJsonMap) {
        for (KConfigMenuItem kConfigMenuItem : children) {
            String type = kConfigMenuItem.getType();
            String configKey = kConfigMenuItem.getId();
            boolean isVisible = false;
            if (type.equals("string") || type.equals("hex") || type.equals("bool") || type.equals("int")) {
                isVisible = this.isVisible(visibleJsonMap, configKey);
                if (!isVisible) continue;
                return true;
            }
            if (type.equals("choice")) {
                List<KConfigMenuItem> choiceItems = kConfigMenuItem.getChildren();
                for (KConfigMenuItem item : choiceItems) {
                    String localConfigKey = item.getId();
                    isVisible = this.isVisible(visibleJsonMap, localConfigKey);
                    if (!isVisible) continue;
                    return true;
                }
                continue;
            }
            if (kConfigMenuItem.isMenuConfig) {
                return true;
            }
            if (!type.equals("menu")) continue;
            return this.isVisible(kConfigMenuItem.getChildren(), visibleJsonMap);
        }
        return false;
    }

    private boolean isVisible(JSONObject visibleJsonMap, String configKey) {
        return visibleJsonMap.get((Object)configKey) != null ? (Boolean)visibleJsonMap.get((Object)configKey) : false;
    }
}

