/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.cdt.lsp.config.ConfigurationMetadata;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;

public abstract class ConfigurationMetadataBase
implements ConfigurationMetadata {
    private final Map<String, PreferenceMetadata<?>> defined = new LinkedHashMap();

    public ConfigurationMetadataBase() {
        this.definePreferences().forEach(d -> {
            PreferenceMetadata preferenceMetadata = this.defined.put(d.identifer(), (PreferenceMetadata<?>)d);
        });
    }

    protected abstract List<PreferenceMetadata<?>> definePreferences();

    protected final List<PreferenceMetadata<?>> overrideOne(List<PreferenceMetadata<?>> input, PreferenceMetadata<?> with) {
        return this.overrideList(input, List.of(with));
    }

    protected final List<PreferenceMetadata<?>> overrideList(List<PreferenceMetadata<?>> input, List<PreferenceMetadata<?>> with) {
        Map overrides = with.stream().collect(Collectors.toMap(PreferenceMetadata::identifer, Function.identity()));
        ArrayList result = new ArrayList();
        for (PreferenceMetadata<?> metadata : input) {
            Optional<PreferenceMetadata> found = Optional.ofNullable((PreferenceMetadata)overrides.remove(metadata.identifer()));
            result.add(found.orElse(metadata));
        }
        overrides.values().forEach(result::add);
        return result;
    }

    protected final PreferenceMetadata<Boolean> overrideBoolean(PreferenceMetadata<Boolean> predefined, boolean override) {
        return new PreferenceMetadata(predefined.valueClass(), predefined.identifer(), (Object)override, predefined.name(), predefined.description());
    }

    protected final PreferenceMetadata<byte[]> overrideByteArray(PreferenceMetadata<byte[]> predefined, byte[] override) {
        return new PreferenceMetadata(predefined.valueClass(), predefined.identifer(), (Object)override, predefined.name(), predefined.description());
    }

    protected final PreferenceMetadata<Double> overrideDouble(PreferenceMetadata<Double> predefined, double override) {
        return new PreferenceMetadata(predefined.valueClass(), predefined.identifer(), (Object)override, predefined.name(), predefined.description());
    }

    protected final PreferenceMetadata<Float> overrideFloat(PreferenceMetadata<Float> predefined, float override) {
        return new PreferenceMetadata(predefined.valueClass(), predefined.identifer(), (Object)Float.valueOf(override), predefined.name(), predefined.description());
    }

    protected final PreferenceMetadata<Integer> overrideInt(PreferenceMetadata<Integer> predefined, int override) {
        return new PreferenceMetadata(predefined.valueClass(), predefined.identifer(), (Object)override, predefined.name(), predefined.description());
    }

    protected final PreferenceMetadata<Long> overrideLong(PreferenceMetadata<Long> predefined, long override) {
        return new PreferenceMetadata(predefined.valueClass(), predefined.identifer(), (Object)override, predefined.name(), predefined.description());
    }

    protected final PreferenceMetadata<String> overrideString(PreferenceMetadata<String> predefined, String override) {
        return new PreferenceMetadata(predefined.valueClass(), predefined.identifer(), (Object)override, predefined.name(), predefined.description());
    }

    @Override
    public final List<PreferenceMetadata<?>> defined() {
        return List.copyOf(this.defined.values());
    }

    @Override
    public final <V> Optional<PreferenceMetadata<V>> defined(String id, Class<V> type) {
        return Optional.ofNullable(id).map(this.defined::get).filter(p -> Objects.equals(p.valueClass(), type)).map(p -> p);
    }
}

