/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.NewGdbRemoteTCPTargetWizard;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.cdt.serial.StandardBaudRates;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.ILaunchTargetWorkingCopy;
import org.eclipse.launchbar.core.target.LaunchTargetUtils;
import org.eclipse.launchbar.ui.target.LaunchTargetWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewGdbRemoteSerialTargetWizard
extends LaunchTargetWizard {
    private Button sameAsPortname;
    private Text nameText;
    private Combo portCombo;
    private Combo baudCombo;
    private static List<String> existingLaunchTargetNames = LaunchTargetUtils.getExistingLaunchTargetNames();
    private String originalName = "";

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new SerialPage());
    }

    public boolean performFinish() {
        ILaunchTargetManager manager = GdbUIPlugin.getService(ILaunchTargetManager.class);
        String id = this.nameText.getText();
        ILaunchTarget target = this.getLaunchTarget();
        if (target == null) {
            target = manager.addLaunchTarget("org.eclipse.cdt.dsf.gdb.remoteSerialLaunchTargetType", id);
        }
        ILaunchTargetWorkingCopy wc = target.getWorkingCopy();
        wc.setId(id);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.DEV", this.portCombo.getText());
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.DEV_SPEED", this.baudCombo.getText());
        wc.save();
        return true;
    }

    public boolean canDelete() {
        return true;
    }

    public void performDelete() {
        ILaunchTargetManager manager = GdbUIPlugin.getService(ILaunchTargetManager.class);
        ILaunchTarget target = this.getLaunchTarget();
        if (target != null) {
            manager.removeLaunchTarget(target);
        }
    }

    private class SerialPage
    extends WizardPage {
        public SerialPage() {
            super(NewGdbRemoteTCPTargetWizard.class.getName());
            this.setTitle(LaunchUIMessages.getString("NewGDBRemoteSerialTargetWizard_Title"));
            this.setDescription(LaunchUIMessages.getString("NewGDBRemoteSerialTargetWizard_Desc"));
        }

        public void createControl(Composite parent) {
            String[] portNames;
            Composite control = new Composite(parent, 0);
            control.setLayout((Layout)new GridLayout());
            String targetName = "";
            String serialPort = "";
            String baudRate = String.valueOf(StandardBaudRates.getDefault());
            ILaunchTarget launchTarget = NewGdbRemoteSerialTargetWizard.this.getLaunchTarget();
            try {
                portNames = SerialPort.list();
            }
            catch (IOException e) {
                GdbUIPlugin.log(e);
                portNames = new String[]{};
            }
            if (launchTarget != null) {
                NewGdbRemoteSerialTargetWizard.this.originalName = targetName = launchTarget.getId();
                serialPort = launchTarget.getAttribute("org.eclipse.cdt.dsf.gdb.DEV", serialPort);
                baudRate = launchTarget.getAttribute("org.eclipse.cdt.dsf.gdb.DEV_SPEED", baudRate);
            }
            Group nameGroup = new Group(control, 0);
            nameGroup.setText(LaunchUIMessages.getString("NewGDBRemoteSerialTargetWizard_NameGroup"));
            nameGroup.setLayout((Layout)new GridLayout(2, false));
            nameGroup.setLayoutData((Object)new GridData(768));
            NewGdbRemoteSerialTargetWizard.this.sameAsPortname = new Button((Composite)nameGroup, 32);
            NewGdbRemoteSerialTargetWizard.this.sameAsPortname.setText(LaunchUIMessages.getString("NewGDBRemoteSerialTargetWizard_SameAsSerialPort"));
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            NewGdbRemoteSerialTargetWizard.this.sameAsPortname.setLayoutData((Object)gridData);
            NewGdbRemoteSerialTargetWizard.this.sameAsPortname.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean same = ((SerialPage)SerialPage.this).NewGdbRemoteSerialTargetWizard.this.sameAsPortname.getSelection();
                    if (same) {
                        ((SerialPage)SerialPage.this).NewGdbRemoteSerialTargetWizard.this.nameText.setText(((SerialPage)SerialPage.this).NewGdbRemoteSerialTargetWizard.this.portCombo.getText());
                    }
                    ((SerialPage)SerialPage.this).NewGdbRemoteSerialTargetWizard.this.nameText.setEnabled(!same);
                }
            });
            NewGdbRemoteSerialTargetWizard.this.sameAsPortname.setSelection(targetName.equals(serialPort));
            Label nameLabel = new Label((Composite)nameGroup, 0);
            nameLabel.setText(LaunchUIMessages.getString("NewGDBRemoteSerialTargetWizard_TargetName"));
            NewGdbRemoteSerialTargetWizard.this.nameText = new Text((Composite)nameGroup, 2048);
            NewGdbRemoteSerialTargetWizard.this.nameText.setText(targetName);
            NewGdbRemoteSerialTargetWizard.this.nameText.setLayoutData((Object)new GridData(768));
            NewGdbRemoteSerialTargetWizard.this.nameText.setEnabled(!targetName.equals(serialPort));
            NewGdbRemoteSerialTargetWizard.this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SerialPage.this.validatePage();
                }
            });
            Group connGroup = new Group(control, 0);
            connGroup.setText(LaunchUIMessages.getString("NewGDBRemoteSerialTargetWizard_ConnectionGroup"));
            connGroup.setLayout((Layout)new GridLayout(2, false));
            connGroup.setLayoutData((Object)new GridData(768));
            Label portLabel = new Label((Composite)connGroup, 0);
            portLabel.setText(LaunchUIMessages.getString("NewGDBRemoteSerialTargetWizard_SerialPort"));
            NewGdbRemoteSerialTargetWizard.this.portCombo = new Combo((Composite)connGroup, 4);
            NewGdbRemoteSerialTargetWizard.this.portCombo.setLayoutData((Object)new GridData(768));
            NewGdbRemoteSerialTargetWizard.this.portCombo.setItems(portNames);
            NewGdbRemoteSerialTargetWizard.this.portCombo.setText(serialPort);
            NewGdbRemoteSerialTargetWizard.this.portCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (((SerialPage)SerialPage.this).NewGdbRemoteSerialTargetWizard.this.sameAsPortname.getSelection()) {
                        ((SerialPage)SerialPage.this).NewGdbRemoteSerialTargetWizard.this.nameText.setText(((SerialPage)SerialPage.this).NewGdbRemoteSerialTargetWizard.this.portCombo.getText());
                    }
                    SerialPage.this.validatePage();
                }
            });
            Label baudLabel = new Label((Composite)connGroup, 0);
            baudLabel.setText(LaunchUIMessages.getString("NewGDBRemoteSerialTargetWizard_BaudRate"));
            NewGdbRemoteSerialTargetWizard.this.baudCombo = new Combo((Composite)connGroup, 4);
            NewGdbRemoteSerialTargetWizard.this.baudCombo.setLayoutData((Object)new GridData(768));
            NewGdbRemoteSerialTargetWizard.this.baudCombo.setItems(StandardBaudRates.asStringArray());
            NewGdbRemoteSerialTargetWizard.this.baudCombo.setText(baudRate);
            NewGdbRemoteSerialTargetWizard.this.baudCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SerialPage.this.validatePage();
                }
            });
            this.setControl((Control)control);
        }

        private void validatePage() {
            this.setPageComplete(false);
            String port = NewGdbRemoteSerialTargetWizard.this.portCombo.getText();
            if (port.isBlank()) {
                this.setErrorMessage(LaunchUIMessages.getString("NewGDBRemoteSerialTargetWizard_NoSerialPort"));
                return;
            }
            try {
                Object[] ports = SerialPort.list();
                Arrays.sort(ports);
                if (Arrays.binarySearch(ports, port) < 0) {
                    this.setMessage("Serial port not found on this system", 2);
                } else {
                    this.setMessage(null, 2);
                }
            }
            catch (IOException e) {
                this.setErrorMessage(e.getLocalizedMessage());
                return;
            }
            String baud = NewGdbRemoteSerialTargetWizard.this.baudCombo.getText();
            if (baud.isBlank()) {
                this.setErrorMessage(LaunchUIMessages.getString("NewGDBRemoteSerialTargetWizard_NoBaudRate"));
                return;
            }
            try {
                Integer.parseInt(baud);
            }
            catch (NumberFormatException e) {
                this.setErrorMessage(LaunchUIMessages.getString("NewGDBRemoteSerialTargetWizard_BaudNotANumber"));
                return;
            }
            if (NewGdbRemoteSerialTargetWizard.this.nameText.getText().isBlank()) {
                this.setErrorMessage(LaunchUIMessages.getString("NewGDBRemoteSerialTargetWizard_NoTargetName"));
                return;
            }
            if (!NewGdbRemoteSerialTargetWizard.this.originalName.equals(NewGdbRemoteSerialTargetWizard.this.nameText.getText().trim()) && existingLaunchTargetNames.contains(NewGdbRemoteSerialTargetWizard.this.nameText.getText().trim())) {
                this.setErrorMessage(LaunchUIMessages.getString("NewGdbRemoteSerialTargetWizard_DuplicateName"));
                return;
            }
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }

        public boolean isPageComplete() {
            return NewGdbRemoteSerialTargetWizard.this.portCombo != null && !NewGdbRemoteSerialTargetWizard.this.portCombo.getText().isBlank() && NewGdbRemoteSerialTargetWizard.this.baudCombo != null && !NewGdbRemoteSerialTargetWizard.this.baudCombo.getText().isBlank() && NewGdbRemoteSerialTargetWizard.this.nameText != null && !NewGdbRemoteSerialTargetWizard.this.nameText.getText().isBlank() && this.getErrorMessage() == null;
        }
    }
}

