/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.presentation;

import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class DisassemblyIPAnnotation
extends Annotation
implements IAnnotationPresentation {
    public static final String ID_TOP = "org.eclipse.debug.ui.currentIP";
    public static final String ID_SECONDARY = "org.eclipse.debug.ui.secondaryIP";
    private Image fImage;
    private int fContext = Integer.MIN_VALUE;

    public DisassemblyIPAnnotation(boolean isTopFrame, int context) {
        super(isTopFrame ? ID_TOP : ID_SECONDARY, false, isTopFrame ? DisassemblyMessages.DisassemblyIPAnnotation_primary : DisassemblyMessages.DisassemblyIPAnnotation_secondary);
        this.setContext(context);
    }

    public boolean isTopFrame() {
        return ID_TOP.equals(this.getType());
    }

    public void setContext(int context) {
        if (context == this.fContext) {
            return;
        }
        this.fContext = context;
        this.fImage = this.isTopFrame() ? DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER_TOP") : DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER");
    }

    public int getLayer() {
        return 5;
    }

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        Rectangle imageBounds = this.fImage.getBounds();
        gc.drawImage(this.fImage, bounds.x + (bounds.width - imageBounds.width) / 2, bounds.y + (bounds.height - imageBounds.height) / 2);
    }
}

