/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.ui;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.debug.gdbjtag.openocd.Activator;
import com.espressif.idf.debug.gdbjtag.openocd.ui.Messages;
import com.espressif.idf.ui.EclipseUtil;
import java.util.Optional;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.launch.ui.CMainTab2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class TabMain
extends CMainTab2 {
    public TabMain() {
        super((Activator.getInstance().getDefaultPreferences().getTabMainCheckProgram() ? 0 : 2) | 8);
    }

    protected void initializeProgramName(ICElement cElement, ILaunchConfigurationWorkingCopy config) {
        String name;
        boolean renamed = false;
        IBinary binary = null;
        if (!(cElement instanceof IBinary)) {
            cElement = cElement.getCProject();
        }
        if (cElement instanceof ICProject) {
            IProject project = cElement.getCProject().getProject();
            Object name2 = project.getName();
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
            if (projDes != null && projDes.getActiveConfiguration() != null) {
                String buildConfigName = projDes.getActiveConfiguration().getName();
                name2 = (String)name2 + " " + buildConfigName;
            }
            name2 = this.getLaunchConfigurationDialog().generateName((String)name2);
            config.rename((String)name2);
            renamed = true;
            IPath elfFilePath = IDFUtil.getELFFilePath((IProject)project);
            IBinary[] bins = this.getBinaryFiles((ICProject)cElement);
            if (bins != null) {
                IBinary[] iBinaryArray = bins;
                int n = bins.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinary iBinary = iBinaryArray[n2];
                    if (iBinary.getResource().getName().equals(elfFilePath.toFile().getName())) {
                        binary = iBinary;
                        break;
                    }
                    ++n2;
                }
            }
        } else if (cElement instanceof IBinary) {
            binary = (IBinary)cElement;
        }
        if (binary != null && !renamed) {
            name = binary.getElementName();
            int index = name.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(0, index);
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
            renamed = true;
        }
        if (!renamed) {
            name = this.getLaunchConfigurationDialog().generateName(cElement.getCProject().getElementName());
            config.rename(name);
        }
    }

    protected void updateProgramFromConfig(ILaunchConfiguration config) {
        if (this.fProgText != null) {
            String programName = "";
            try {
                programName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "${default_app}");
                programName = programName.isBlank() ? "${default_app}" : programName;
            }
            catch (CoreException ce) {
                Logger.log((Exception)((Object)ce));
            }
            this.fProgText.setText(programName);
        }
    }

    protected void createBuildConfigCombo(Composite parent, int colspan) {
        Composite comboComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        comboComp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colspan;
        comboComp.setLayoutData((Object)gd);
        Link dlabel = new Link(comboComp, 0);
        dlabel.setText(Messages.TabMain_Launch_Config);
        this.fBuildConfigCombo = new Combo(comboComp, 12);
        this.fBuildConfigCombo.setLayoutData((Object)new GridData(768));
        this.fBuildConfigCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabMain.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void updateBuildOptionFromConfig(ILaunchConfiguration config) {
        int buildBeforeLaunchValue = 2;
        try {
            buildBeforeLaunchValue = config.getAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", buildBeforeLaunchValue);
            String configName = "";
            configName = config.getAttribute("com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationName", configName);
            this.updateBuildConfigCombo(configName);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        if (this.fDisableBuildButton != null) {
            this.fDisableBuildButton.setSelection(buildBeforeLaunchValue == 0);
        }
        if (this.fEnableBuildButton != null) {
            this.fEnableBuildButton.setSelection(buildBeforeLaunchValue == 1);
        }
        if (this.fWorkspaceSettingsButton != null) {
            this.fWorkspaceSettingsButton.setSelection(buildBeforeLaunchValue == 2);
        }
    }

    protected void updateBuildConfigCombo(String selectedConfigName) {
        this.fBuildConfigCombo.removeAll();
        int offset = 0;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = launchManager.getLaunchConfigurations(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.espressif.idf.launch.serial.launchConfigurationType"));
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                IResource[] mappedResource = config.getMappedResources();
                if (mappedResource != null && mappedResource[0].getProject().getName().contentEquals(this.fProjText.getText())) {
                    this.fBuildConfigCombo.add(config.getName());
                    if (config.getName().contentEquals(selectedConfigName)) {
                        this.fBuildConfigCombo.select(offset);
                    }
                    ++offset;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        if (this.fBuildConfigCombo.getText().isBlank()) {
            this.fBuildConfigCombo.select(0);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        Optional selectedProject = EclipseUtil.getDefaultIDFProject();
        selectedProject.ifPresent(project -> this.initializeDefaultProject((IProject)project, configuration));
    }

    private void initializeDefaultProject(IProject project, ILaunchConfigurationWorkingCopy configuration) {
        ICProject icProject = CCorePlugin.getDefault().getCoreModel().create(project);
        this.initializeCProject((ICElement)icProject, configuration);
        this.initializeProgramName((ICElement)icProject, configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        ICProject cProject;
        config.setAttribute("com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationName", this.fBuildConfigCombo.getText());
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "AUTO");
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_AUTO_ATTR", true);
        if (this.fDisableBuildButton != null) {
            int buildBeforeLaunchValue = 2;
            if (this.fDisableBuildButton.getSelection()) {
                buildBeforeLaunchValue = 0;
            } else if (this.fEnableBuildButton.getSelection()) {
                buildBeforeLaunchValue = 1;
            }
            config.setAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", buildBeforeLaunchValue);
        }
        if ((cProject = this.getCProject()) != null && cProject.exists()) {
            config.setMappedResources(new IResource[]{cProject.getProject()});
        } else {
            config.setMappedResources(null);
        }
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.fProjText.getText());
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.fProgText.getText().isBlank() ? "${default_app}" : this.fProgText.getText());
        if (this.fCoreText != null) {
            config.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", this.fCoreText.getText());
            config.setAttribute("org.eclipse.cdt.dsf.gdb.POST_MORTEM_TYPE", this.getSelectedCoreType());
        }
    }
}

