/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.heaptracing;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.breakpointactions.AbstractBreakpointAction;
import org.eclipse.cdt.debug.core.breakpointactions.ICLIDebugActionEnabler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HeapTracingAction
extends AbstractBreakpointAction {
    public static final String ID = "com.espressif.idf.debug.gdbjtag.openocd.heaptracing.HeapTracingAction";
    private String command;
    private String fileName;
    private static final String COMMAND_ATT = "command";
    private static final String FILENAME_ATT = "fileName";
    private static final String START_ATT = "start";
    private static final String START_COMMAND = "mon esp sysview_mcore start file://";
    private static final String STOP_COMMAND = "mon esp sysview_mcore stop";
    private static final String DEFAULT_NAME = "Heap Tracing Action";
    private boolean startHeapTracing;

    public void setCommand(String command) {
        this.command = command;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName.replace('\\', '/');
    }

    public String getCommand() {
        this.command = this.startHeapTracing ? START_COMMAND.concat(this.getFileName()) : STOP_COMMAND;
        return this.command;
    }

    public String getMemento() {
        try {
            Document doc = DebugPlugin.newDocument();
            Element rootElement = doc.createElement(COMMAND_ATT);
            rootElement.setAttribute(COMMAND_ATT, this.command);
            rootElement.setAttribute(FILENAME_ATT, this.fileName);
            rootElement.setAttribute(START_ATT, String.valueOf(this.startHeapTracing));
            doc.appendChild(rootElement);
            return DebugPlugin.serializeDocument((Document)doc);
        }
        catch (CoreException | DOMException e) {
            CDebugUIPlugin.log((Throwable)e);
            return "";
        }
    }

    public void initializeFromMemento(String data) {
        try {
            Element root = DebugPlugin.parseDocument((String)data);
            String value = root.getAttribute(COMMAND_ATT);
            if (value == null) {
                value = "";
            }
            this.command = value;
            value = root.getAttribute(FILENAME_ATT);
            if (value == null) {
                value = "";
            }
            this.fileName = value;
            value = root.getAttribute(START_ATT);
            this.startHeapTracing = value == null ? false : Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            CDebugUIPlugin.log((Throwable)e);
        }
    }

    public String getDefaultName() {
        return DEFAULT_NAME;
    }

    public String getSummary() {
        String summary = this.getCommand();
        if (summary.length() > 32) {
            summary = summary.substring(0, 32);
        }
        return summary;
    }

    public String getTypeName() {
        return DEFAULT_NAME;
    }

    public String getIdentifier() {
        return ID;
    }

    public IStatus execute(IBreakpoint breakpoint, IAdaptable context, IProgressMonitor monitor) {
        ICLIDebugActionEnabler enabler = (ICLIDebugActionEnabler)context.getAdapter(ICLIDebugActionEnabler.class);
        if (enabler != null) {
            try {
                enabler.execute(this.getCommand());
            }
            catch (Exception e) {
                return this.errorStatus(e);
            }
        } else {
            return new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, "Your debugger integration does not support direct execution of commands", null);
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    private IStatus errorStatus(Exception ex) {
        String errorMsg = MessageFormat.format("Could not execute debugger command action {0}", this.getSummary());
        return new Status(4, this.getIdentifier(), 10002, errorMsg, (Throwable)ex);
    }

    public boolean isStartHeapTracing() {
        return this.startHeapTracing;
    }

    public void setStartHeapTracing(boolean startHeapTracing) {
        this.startHeapTracing = startHeapTracing;
    }
}

