/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.heaptracing;

import com.espressif.idf.debug.gdbjtag.openocd.heaptracing.HeapTracingBreakpointActionPage;
import com.espressif.idf.debug.gdbjtag.openocd.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HeapTraceComposite
extends Composite {
    public static final String COMPOSITE_NAME = "start_heap_trace_composite";
    private Text textHeapTraceFile;
    private Button btnStartHeapTraceRadio;
    private Button btnStopHeapTraceRadio;
    private Button btnBrowse;
    private boolean startHeapTracing;

    public HeapTraceComposite(final Composite parent, int style, HeapTracingBreakpointActionPage heapTracingBreakpointActionPage) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        Group radioBtnGroup = new Group((Composite)this, 0);
        radioBtnGroup.setLayout((Layout)new RowLayout(256));
        radioBtnGroup.setText(Messages.BreakPointPage_RadioGroupTitle);
        GridData groupGridData = new GridData();
        groupGridData.horizontalSpan = 3;
        groupGridData.horizontalAlignment = 4;
        groupGridData.grabExcessHorizontalSpace = true;
        radioBtnGroup.setLayoutData((Object)groupGridData);
        this.btnStartHeapTraceRadio = new Button((Composite)radioBtnGroup, 16);
        this.btnStartHeapTraceRadio.setText(Messages.BreakPointPage_BtnStartHeapTrace);
        this.btnStartHeapTraceRadio.addSelectionListener((SelectionListener)new BtnRadioSelectionListener(true));
        this.btnStopHeapTraceRadio = new Button((Composite)radioBtnGroup, 16);
        this.btnStopHeapTraceRadio.setText(Messages.BreakPointPage_BtnStopHeapTrace);
        this.btnStopHeapTraceRadio.addSelectionListener((SelectionListener)new BtnRadioSelectionListener(false));
        Label messageToLogLabel = new Label((Composite)this, 0);
        messageToLogLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        messageToLogLabel.setText(Messages.BreakPointPage_TextHeapDumpFileName);
        this.textHeapTraceFile = new Text((Composite)this, 2048);
        this.textHeapTraceFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnBrowse = new Button((Composite)this, 8);
        this.btnBrowse.setText(Messages.BreakPointPage_BtnBrowse);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getDisplay().getActiveShell(), 8192);
                dialog.setFilterNames(new String[]{"*.svdat"});
                dialog.setFilterExtensions(new String[]{"*.svdat"});
                dialog.setFilterPath(System.getProperty("user.dir"));
                String fName = dialog.open();
                HeapTraceComposite.this.textHeapTraceFile.setText(fName.replace('\\', '/'));
            }
        });
        if (heapTracingBreakpointActionPage.getAction().isStartHeapTracing()) {
            String fName = heapTracingBreakpointActionPage.getAction().getFileName();
            this.textHeapTraceFile.setText(fName == null ? "" : fName);
            this.textHeapTraceFile.setEnabled(true);
            this.btnStartHeapTraceRadio.setSelection(true);
            this.btnStopHeapTraceRadio.setSelection(false);
            this.btnBrowse.setEnabled(true);
        } else {
            this.textHeapTraceFile.setEnabled(false);
            this.btnStartHeapTraceRadio.setSelection(false);
            this.btnStopHeapTraceRadio.setSelection(true);
            this.btnBrowse.setEnabled(false);
        }
    }

    public String getHeapTraceFile() {
        return this.textHeapTraceFile.getText();
    }

    public boolean isStartHeapTracing() {
        return this.startHeapTracing;
    }

    public void setStartHeapTracing(boolean startHeapTracing) {
        this.startHeapTracing = startHeapTracing;
    }

    private class BtnRadioSelectionListener
    extends SelectionAdapter {
        private boolean startHeapTrace;

        private BtnRadioSelectionListener(boolean startHeapTrace) {
            this.startHeapTrace = startHeapTrace;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.startHeapTrace) {
                this.startHeapTrace();
            } else {
                this.stopHeapTrace();
            }
        }

        private void stopHeapTrace() {
            HeapTraceComposite.this.textHeapTraceFile.setEnabled(false);
            HeapTraceComposite.this.btnStartHeapTraceRadio.setSelection(false);
            HeapTraceComposite.this.btnStopHeapTraceRadio.setSelection(true);
            HeapTraceComposite.this.setStartHeapTracing(false);
            HeapTraceComposite.this.btnBrowse.setEnabled(false);
        }

        private void startHeapTrace() {
            HeapTraceComposite.this.textHeapTraceFile.setEnabled(true);
            HeapTraceComposite.this.btnStopHeapTraceRadio.setSelection(false);
            HeapTraceComposite.this.btnStartHeapTraceRadio.setSelection(true);
            HeapTraceComposite.this.setStartHeapTracing(true);
            HeapTraceComposite.this.btnBrowse.setEnabled(true);
        }
    }
}

