/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.dsf;

import com.espressif.idf.debug.gdbjtag.openocd.Activator;
import com.espressif.idf.debug.gdbjtag.openocd.Configuration;
import com.espressif.idf.debug.gdbjtag.openocd.dsf.GdbServerBackend;
import com.espressif.idf.debug.gdbjtag.openocd.dsf.LaunchProcessDictionary;
import com.espressif.idf.debug.gdbjtag.openocd.preferences.DefaultPreferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.embedcdt.debug.gdbjtag.core.dsf.GnuMcuLaunch;

public class Launch
extends GnuMcuLaunch {
    ILaunchConfiguration fConfig = null;
    private DsfSession fSession;
    private DsfServicesTracker fTracker;
    private DefaultDsfExecutor fExecutor;
    private IProcess openOcdServerProcess;
    private IProcess gdbIProcess;
    private static final String SERVER_PROC_KEY = "SERVER_PROC";
    private static final String GDB_PROC_KEY = "GDB_PROC";

    public Launch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.Launch.launch(" + launchConfiguration.getName() + "," + mode + ") " + String.valueOf((Object)this));
        }
        this.fConfig = launchConfiguration;
        this.fExecutor = (DefaultDsfExecutor)this.getDsfExecutor();
        this.fSession = this.getSession();
    }

    public void initialize() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.Launch.initialize() " + String.valueOf((Object)this));
        }
        super.initialize();
        DsfRunnable initRunnable = new DsfRunnable(){

            public void run() {
                Launch.this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), Launch.this.fSession.getId());
            }
        };
        try {
            this.cleanUpOldLaunchProcesses();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            this.fExecutor.submit((Runnable)initRunnable).get();
        }
        catch (InterruptedException e) {
            new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 10005, "Error initializing launch", (Throwable)e);
        }
        catch (ExecutionException e) {
            new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 10005, "Error initializing launch", (Throwable)e);
        }
    }

    protected void provideDefaults(ILaunchConfigurationWorkingCopy config) throws CoreException {
        super.provideDefaults(config);
        if (!config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress")) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost");
        }
        if (!config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDeviceId")) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDeviceId", "ESP-IDF GDB OpenOCD");
        }
        if (!config.hasAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber")) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 3333);
        }
        if (!config.hasAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME")) {
            DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
            config.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", fDefaultPreferences.getGdbClientExecutable());
        }
        if (Configuration.getDoStartGdbServer((ILaunchConfiguration)config)) {
            config.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 3333);
        }
        config.setAttribute("process_factory_id", "com.espressif.idf.debug.gdbjtag.openocd.processFactory");
    }

    public void initializeServerConsole(IProgressMonitor monitor) throws CoreException {
        boolean doAddServerConsole;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.Launch.initializeServerConsole()");
        }
        if (doAddServerConsole = Configuration.getDoAddServerConsole(this.fConfig)) {
            this.openOcdServerProcess = this.addServerProcess(Configuration.getGdbServerCommandName(this.fConfig));
            LaunchProcessDictionary.getInstance().addProcessToDictionary(this.getLaunchConfiguration().getName(), SERVER_PROC_KEY, this.openOcdServerProcess);
            monitor.worked(1);
        }
    }

    public void initializeConsoles(IProgressMonitor monitor) throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.Launch.initializeConsoles()");
        }
        this.gdbIProcess = this.addClientProcess(Configuration.getGdbClientCommandName(this.fConfig));
        this.gdbIProcess.setAttribute(IProcess.ATTR_CMDLINE, Configuration.getGdbClientCommandLine(this.fConfig));
        LaunchProcessDictionary.getInstance().addProcessToDictionary(this.getLaunchConfiguration().getName(), GDB_PROC_KEY, this.gdbIProcess);
        monitor.worked(1);
    }

    public IProcess addServerProcess(String label) throws CoreException {
        IProcess newProcess = null;
        try {
            Process serverProc = (Process)this.getDsfExecutor().submit((Callable)new Callable<Process>(){

                @Override
                public Process call() throws CoreException {
                    GdbServerBackend backend = (GdbServerBackend)((Object)Launch.this.fTracker.getService(GdbServerBackend.class));
                    if (backend != null) {
                        return backend.getServerProcess();
                    }
                    return null;
                }
            }).get();
            HashMap attributes = new HashMap();
            if (serverProc != null) {
                newProcess = DebugPlugin.newProcess((ILaunch)this, (Process)serverProc, (String)label, attributes);
            }
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
        return newProcess;
    }

    public void terminate() throws DebugException {
        super.terminate();
        LaunchProcessDictionary.getInstance().killAllProcessesInLaunch(this.getLaunchConfiguration().getName());
    }

    public boolean canDisconnect() {
        return true;
    }

    public boolean canTerminate() {
        return true;
    }

    public IProcess[] getProcesses() {
        ArrayList<IProcess> processes = new ArrayList<IProcess>();
        if (this.openOcdServerProcess != null) {
            processes.add(this.openOcdServerProcess);
        }
        if (this.gdbIProcess != null) {
            processes.add(this.gdbIProcess);
        }
        return processes.toArray(new IProcess[0]);
    }

    private void cleanUpOldLaunchProcesses() throws CoreException {
        IProcess gdbIProcess;
        IProcess serverIProcess = LaunchProcessDictionary.getInstance().getProcessFromDictionary(this.getLaunchConfiguration().getName(), SERVER_PROC_KEY);
        if (serverIProcess != null && !serverIProcess.isTerminated()) {
            serverIProcess.terminate();
        }
        if ((gdbIProcess = LaunchProcessDictionary.getInstance().getProcessFromDictionary(this.getLaunchConfiguration().getName(), GDB_PROC_KEY)) != null && !gdbIProcess.isTerminated()) {
            gdbIProcess.terminate();
        }
    }
}

